/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.securechannel;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.securechannel.ChannelEntryPoint;
import net.sf.acegisecurity.util.PortMapper;
import net.sf.acegisecurity.util.PortMapperImpl;
import net.sf.acegisecurity.util.PortResolver;
import net.sf.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class RetryWithHttpsEntryPoint
implements InitializingBean,
ChannelEntryPoint {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$securechannel$RetryWithHttpsEntryPoint == null ? (class$net$sf$acegisecurity$securechannel$RetryWithHttpsEntryPoint = RetryWithHttpsEntryPoint.class$("net.sf.acegisecurity.securechannel.RetryWithHttpsEntryPoint")) : class$net$sf$acegisecurity$securechannel$RetryWithHttpsEntryPoint));
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    static /* synthetic */ Class class$net$sf$acegisecurity$securechannel$RetryWithHttpsEntryPoint;

    public void setPortMapper(PortMapper portMapper) {
        this.portMapper = portMapper;
    }

    public PortMapper getPortMapper() {
        return this.portMapper;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.portMapper == null) {
            throw new IllegalArgumentException("portMapper is required");
        }
        if (this.portResolver == null) {
            throw new IllegalArgumentException("portResolver is required");
        }
    }

    public void commence(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        String contextPath = req.getContextPath();
        String destination = req.getServletPath() + (pathInfo == null ? "" : pathInfo) + (queryString == null ? "" : "?" + queryString);
        String redirectUrl = contextPath;
        Integer httpPort = new Integer(this.portResolver.getServerPort((ServletRequest)req));
        Integer httpsPort = this.portMapper.lookupHttpsPort(httpPort);
        if (httpsPort != null) {
            boolean includePort = true;
            if (httpsPort == 443) {
                includePort = false;
            }
            redirectUrl = "https://" + req.getServerName() + (includePort ? ":" + httpsPort : "") + contextPath + destination;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Redirecting to: " + redirectUrl));
        }
        ((HttpServletResponse)response).sendRedirect(((HttpServletResponse)response).encodeRedirectURL(redirectUrl));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

