/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.ember;

import java.io.IOException;
import java.net.URI;
import javax.jms.JMSException;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportServerChannel;
import org.codehaus.activemq.transport.TransportServerChannelFactory;
import org.codehaus.activemq.transport.ember.EmberSupport;
import org.codehaus.activemq.transport.ember.EmberTransportServerChannel;
import pyrasun.eio.EIOGlobalContext;
import pyrasun.eio.EIOPoolingStrategy;
import pyrasun.eio.services.EmberService;
import pyrasun.eio.services.EmberServiceController;
import pyrasun.eio.services.bytearray.ByteArrayServerListener;
import pyrasun.eio.services.bytearray.ByteArrayServerService;

public class EmberTransportServerChannelFactory
extends EmberSupport
implements TransportServerChannelFactory {
    private EIOPoolingStrategy acceptPoolingStrategy;
    private String acceptPoolingStrategyName = "BLOCKING_ACCEPTOR";

    public EmberTransportServerChannelFactory() {
    }

    public EmberTransportServerChannelFactory(EIOGlobalContext context, EIOPoolingStrategy ioPoolingStrategy, EIOPoolingStrategy acceptPoolingStrategy) {
        super(context, ioPoolingStrategy);
        this.acceptPoolingStrategy = acceptPoolingStrategy;
    }

    public TransportServerChannel create(WireFormat wireFormat, URI bindAddress) throws JMSException {
        try {
            EmberServiceController controller = this.getController();
            ByteArrayServerService service = new ByteArrayServerService(this.getContext(), this.getAcceptPoolingStrategy(), this.getIoPoolingStrategy(), bindAddress.getHost(), bindAddress.getPort());
            controller.addService((EmberService)service);
            EmberTransportServerChannel answer = new EmberTransportServerChannel(wireFormat, bindAddress, this.getContext(), controller);
            service.setListener((ByteArrayServerListener)answer);
            return answer;
        }
        catch (IOException e) {
            throw this.createJMSException("Initialization of TransportServerChannel failed: ", e);
        }
    }

    protected EIOPoolingStrategy getAcceptPoolingStrategy() {
        if (this.acceptPoolingStrategy == null) {
            this.acceptPoolingStrategy = this.getPoolingStrategyByName(this.acceptPoolingStrategyName);
        }
        return this.acceptPoolingStrategy;
    }
}

