/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.jgroups;

import java.net.URI;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelFactorySupport;
import org.codehaus.activemq.transport.jgroups.JGroupsTransportChannel;
import org.codehaus.activemq.util.JMSExceptionHelper;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;

public class JGroupsTransportChannelFactory
extends TransportChannelFactorySupport {
    private static final Log log = LogFactory.getLog((Class)JGroupsTransportChannelFactory.class);
    private ChannelFactory channelFactory = new JChannelFactory();
    private Object channelConfiguration;
    private String channelName = "ActiveMQ";

    public JGroupsTransportChannelFactory() {
    }

    public JGroupsTransportChannelFactory(ChannelFactory channelFactory, Object channelConfiguration, String channelName) {
        this.channelFactory = channelFactory;
        this.channelConfiguration = channelConfiguration;
        this.channelName = channelName;
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            Channel channel = this.createChannel(remoteLocation);
            channel.setOpt(5, (Object)Boolean.TRUE);
            channel.connect(this.channelName);
            return this.populateProperties((TransportChannel)new JGroupsTransportChannel(wireFormat, channel, null), remoteLocation);
        }
        catch (ChannelException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to construct JGroups Channel: " + (Object)((Object)e)), (Exception)((Object)e));
        }
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        return this.create(wireFormat, remoteLocation);
    }

    public boolean requiresEmbeddedBroker() {
        return true;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public Object getChannelConfiguration() {
        return this.channelConfiguration;
    }

    public void setChannelConfiguration(Object channelConfiguration) {
        this.channelConfiguration = channelConfiguration;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    protected Channel createChannel(URI remoteLocation) throws ChannelException {
        String text;
        Object config = this.channelConfiguration;
        if (config == null && !(text = remoteLocation.getSchemeSpecificPart()).equalsIgnoreCase("default")) {
            config = text;
        }
        log.info((Object)("Configuring JGroups with: " + config));
        return this.channelFactory.createChannel(config);
    }
}

