/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb;

import at.grahsl.kafka.connect.mongodb.CollectionAwareConfig;
import at.grahsl.kafka.connect.mongodb.cdc.CdcHandler;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.OperationType;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.mongodb.MongoDbHandler;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsHandler;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.mysql.MysqlHandler;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.postgres.PostgresHandler;
import at.grahsl.kafka.connect.mongodb.processor.BlacklistKeyProjector;
import at.grahsl.kafka.connect.mongodb.processor.BlacklistValueProjector;
import at.grahsl.kafka.connect.mongodb.processor.DocumentIdAdder;
import at.grahsl.kafka.connect.mongodb.processor.PostProcessor;
import at.grahsl.kafka.connect.mongodb.processor.WhitelistKeyProjector;
import at.grahsl.kafka.connect.mongodb.processor.WhitelistValueProjector;
import at.grahsl.kafka.connect.mongodb.processor.field.projection.FieldProjector;
import at.grahsl.kafka.connect.mongodb.processor.field.renaming.FieldnameMapping;
import at.grahsl.kafka.connect.mongodb.processor.field.renaming.RegExpSettings;
import at.grahsl.kafka.connect.mongodb.processor.field.renaming.RenameByRegExp;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.BsonOidStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.FullKeyStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.IdStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.KafkaMetaDataStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.PartialKeyStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.PartialValueStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.ProvidedInKeyStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.ProvidedInValueStrategy;
import at.grahsl.kafka.connect.mongodb.processor.id.strategy.UuidStrategy;
import at.grahsl.kafka.connect.mongodb.writemodel.strategy.DeleteOneDefaultStrategy;
import at.grahsl.kafka.connect.mongodb.writemodel.strategy.WriteModelStrategy;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClientURI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;

public class MongoDbSinkConnectorConfig
extends CollectionAwareConfig {
    private static final Pattern CLASS_NAME = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern FULLY_QUALIFIED_CLASS_NAME = Pattern.compile("(" + CLASS_NAME + "\\.)*" + CLASS_NAME);
    private static final Pattern FULLY_QUALIFIED_CLASS_NAME_LIST = Pattern.compile("(" + FULLY_QUALIFIED_CLASS_NAME + ",)*" + FULLY_QUALIFIED_CLASS_NAME);
    public static final String FIELD_LIST_SPLIT_CHAR = ",";
    public static final String FIELD_LIST_SPLIT_EXPR = "\\s*,\\s*";
    public static final String TOPIC_AGNOSTIC_KEY_NAME = "__default__";
    public static final String MONGODB_NAMESPACE_SEPARATOR = ".";
    public static final String MONGODB_CONNECTION_URI_DEFAULT = "mongodb://localhost:27017/kafkaconnect?w=1&journal=true";
    public static final String MONGODB_COLLECTIONS_DEFAULT = "";
    public static final String MONGODB_COLLECTION_DEFAULT = "";
    public static final int MONGODB_MAX_NUM_RETRIES_DEFAULT = 3;
    public static final int MONGODB_RETRIES_DEFER_TIMEOUT_DEFAULT = 5000;
    public static final String MONGODB_VALUE_PROJECTION_TYPE_DEFAULT = "none";
    public static final String MONGODB_VALUE_PROJECTION_LIST_DEFAULT = "";
    public static final String MONGODB_DOCUMENT_ID_STRATEGY_DEFAULT = "at.grahsl.kafka.connect.mongodb.processor.id.strategy.BsonOidStrategy";
    public static final String MONGODB_DOCUMENT_ID_STRATEGIES_DEFAULT = "";
    public static final String MONGODB_KEY_PROJECTION_TYPE_DEFAULT = "none";
    public static final String MONGODB_KEY_PROJECTION_LIST_DEFAULT = "";
    public static final String MONGODB_FIELD_RENAMER_MAPPING_DEFAULT = "[]";
    public static final String MONGODB_FIELD_RENAMER_REGEXP_DEFAULT = "[]";
    public static final String MONGODB_POST_PROCESSOR_CHAIN_DEFAULT = "at.grahsl.kafka.connect.mongodb.processor.DocumentIdAdder";
    public static final String MONGODB_CHANGE_DATA_CAPTURE_HANDLER_DEFAULT = "";
    public static final String MONGODB_CHANGE_DATA_CAPTURE_HANDLER_OPERATIONS_DEFAULT = "c,r,u,d";
    public static final boolean MONGODB_DELETE_ON_NULL_VALUES_DEFAULT = false;
    public static final String MONGODB_WRITEMODEL_STRATEGY_DEFAULT = "at.grahsl.kafka.connect.mongodb.writemodel.strategy.ReplaceOneDefaultStrategy";
    public static final int MONGODB_MAX_BATCH_SIZE_DEFAULT = 0;
    public static final int MONGODB_RATE_LIMITING_TIMEOUT_DEFAULT = 0;
    public static final int MONGODB_RATE_LIMITING_EVERY_N_DEFAULT = 0;
    public static final String MONGODB_CONNECTION_URI_CONF = "mongodb.connection.uri";
    private static final String MONGODB_CONNECTION_URI_DOC = "the monogdb connection URI as supported by the offical drivers";
    public static final String MONGODB_COLLECTION_CONF = "mongodb.collection";
    private static final String MONGODB_COLLECTION_DOC = "single sink collection name to write to";
    public static final String MONGODB_COLLECTIONS_CONF = "mongodb.collections";
    private static final String MONGODB_COLLECTIONS_DOC = "names of sink collections to write to for which there can be topic-level specific properties defined";
    public static final String MONGODB_MAX_NUM_RETRIES_CONF = "mongodb.max.num.retries";
    private static final String MONGODB_MAX_NUM_RETRIES_DOC = "how often a retry should be done on write errors";
    public static final String MONGODB_RETRIES_DEFER_TIMEOUT_CONF = "mongodb.retries.defer.timeout";
    private static final String MONGODB_RETRIES_DEFER_TIMEOUT_DOC = "how long in ms a retry should get deferred";
    public static final String MONGODB_VALUE_PROJECTION_TYPE_CONF = "mongodb.value.projection.type";
    private static final String MONGODB_VALUE_PROJECTION_TYPE_DOC = "whether or not and which value projection to use";
    public static final String MONGODB_VALUE_PROJECTION_LIST_CONF = "mongodb.value.projection.list";
    private static final String MONGODB_VALUE_PROJECTION_LIST_DOC = "comma separated list of field names for value projection";
    public static final String MONGODB_DOCUMENT_ID_STRATEGY_CONF = "mongodb.document.id.strategy";
    private static final String MONGODB_DOCUMENT_ID_STRATEGY_CONF_DOC = "class name of strategy to use for generating a unique document id (_id)";
    public static final String MONGODB_DOCUMENT_ID_STRATEGIES_CONF = "mongodb.document.id.strategies";
    private static final String MONGODB_DOCUMENT_ID_STRATEGIES_CONF_DOC = "comma separated list of custom strategy classes to register for usage";
    public static final String MONGODB_KEY_PROJECTION_TYPE_CONF = "mongodb.key.projection.type";
    private static final String MONGODB_KEY_PROJECTION_TYPE_DOC = "whether or not and which key projection to use";
    public static final String MONGODB_KEY_PROJECTION_LIST_CONF = "mongodb.key.projection.list";
    private static final String MONGODB_KEY_PROJECTION_LIST_DOC = "comma separated list of field names for key projection";
    public static final String MONGODB_FIELD_RENAMER_MAPPING = "mongodb.field.renamer.mapping";
    private static final String MONGODB_FIELD_RENAMER_MAPPING_DOC = "inline JSON array with objects describing field name mappings";
    public static final String MONGODB_FIELD_RENAMER_REGEXP = "mongodb.field.renamer.regexp";
    private static final String MONGODB_FIELD_RENAMER_REGEXP_DOC = "inline JSON array with objects describing regexp settings";
    public static final String MONGODB_POST_PROCESSOR_CHAIN = "mongodb.post.processor.chain";
    private static final String MONGODB_POST_PROCESSOR_CHAIN_DOC = "comma separated list of post processor classes to build the chain with";
    public static final String MONGODB_CHANGE_DATA_CAPTURE_HANDLER = "mongodb.change.data.capture.handler";
    private static final String MONGODB_CHANGE_DATA_CAPTURE_HANDLER_DOC = "class name of CDC handler to use for processing";
    public static final String MONGODB_CHANGE_DATA_CAPTURE_HANDLER_OPERATIONS = "mongodb.change.data.capture.handler.operations";
    private static final String MONGODB_CHANGE_DATA_CAPTURE_HANDLER_OPERATIONS_DOC = "comma separated list of supported CDC operation types (missing ones result in no ops)";
    public static final String MONGODB_DELETE_ON_NULL_VALUES = "mongodb.delete.on.null.values";
    private static final String MONGODB_DELETE_ON_NULL_VALUES_DOC = "whether or not the connector tries to delete documents based on key when value is null";
    public static final String MONGODB_WRITEMODEL_STRATEGY = "mongodb.writemodel.strategy";
    private static final String MONGODB_WRITEMODEL_STRATEGY_DOC = "how to build the write models for the sink documents";
    public static final String MONGODB_MAX_BATCH_SIZE = "mongodb.max.batch.size";
    private static final String MONGODB_MAX_BATCH_SIZE_DOC = "maximum number of sink records to possibly batch together for processing";
    public static final String MONGODB_RATE_LIMITING_TIMEOUT = "mongodb.rate.limiting.timeout";
    private static final String MONGODB_RATE_LIMITING_TIMEOUT_DOC = "how long in ms processing should wait before continue processing";
    public static final String MONGODB_RATE_LIMITING_EVERY_N = "mongodb.rate.limiting.every.n";
    private static final String MONGODB_RATE_LIMITING_EVERY_N_DOC = "after how many processed batches the rate limit should trigger (NO rate limiting if n=0)";
    private static ObjectMapper objectMapper = new ObjectMapper();

    public MongoDbSinkConnectorConfig(ConfigDef config, Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public MongoDbSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(MongoDbSinkConnectorConfig.conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        return new ConfigDef(){

            private <T> Validator<T> ensureValid(String name, Consumer<T> consumer) {
                return new Validator<T>(name, consumer);
            }

            public Map<String, ConfigValue> validateAll(Map<String, String> props) {
                Map result = super.validateAll(props);
                MongoDbSinkConnectorConfig config = new MongoDbSinkConnectorConfig(props);
                Stream.of(this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_CONNECTION_URI_CONF, MongoDbSinkConnectorConfig::buildClientURI), this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_KEY_PROJECTION_TYPE_CONF, cfg -> cfg.getKeyProjectionList("")), this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_VALUE_PROJECTION_TYPE_CONF, cfg -> cfg.getValueProjectionList("")), this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_FIELD_RENAMER_MAPPING, cfg -> cfg.parseRenameFieldnameMappings("")), this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_FIELD_RENAMER_REGEXP, cfg -> cfg.parseRenameRegExpSettings("")), this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_POST_PROCESSOR_CHAIN, cfg -> cfg.buildPostProcessorChain("")), ((Validator)this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_CHANGE_DATA_CAPTURE_HANDLER, cfg -> cfg.getCdcHandler(""))).unless(config.getString(MongoDbSinkConnectorConfig.MONGODB_CHANGE_DATA_CAPTURE_HANDLER).isEmpty()), this.ensureValid(MongoDbSinkConnectorConfig.MONGODB_DOCUMENT_ID_STRATEGIES_CONF, cfg -> cfg.getIdStrategy(""))).forEach(validator -> {
                    try {
                        ((Validator)validator).accept((Object)config);
                    }
                    catch (Exception ex) {
                        ((ConfigValue)result.get(((Validator)validator).name)).addErrorMessage(ex.getMessage());
                    }
                });
                return result;
            }

            class Validator<T> {
                private final String name;
                private final Consumer<T> consumer;

                Validator(String name, Consumer<T> consumer) {
                    this.name = name;
                    this.consumer = consumer;
                }

                private Validator<T> unless(boolean condition) {
                    return condition ? new Validator<Object>(this.name, t -> {}) : this;
                }

                private void accept(T obj) {
                    this.consumer.accept(obj);
                }
            }
        }.define(MONGODB_CONNECTION_URI_CONF, ConfigDef.Type.STRING, (Object)MONGODB_CONNECTION_URI_DEFAULT, ConfigDef.Importance.HIGH, MONGODB_CONNECTION_URI_DOC).define(MONGODB_COLLECTIONS_CONF, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, MONGODB_COLLECTIONS_DOC).define(MONGODB_COLLECTION_CONF, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, MONGODB_COLLECTION_DOC).define(MONGODB_MAX_NUM_RETRIES_CONF, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MONGODB_MAX_NUM_RETRIES_DOC).define(MONGODB_RETRIES_DEFER_TIMEOUT_CONF, ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MONGODB_RETRIES_DEFER_TIMEOUT_DOC).define(MONGODB_VALUE_PROJECTION_TYPE_CONF, ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)EnumValidator.in(FieldProjectionTypes.values()), ConfigDef.Importance.LOW, MONGODB_VALUE_PROJECTION_TYPE_DOC).define(MONGODB_VALUE_PROJECTION_LIST_CONF, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, MONGODB_VALUE_PROJECTION_LIST_DOC).define(MONGODB_DOCUMENT_ID_STRATEGY_CONF, ConfigDef.Type.STRING, (Object)MONGODB_DOCUMENT_ID_STRATEGY_DEFAULT, (ConfigDef.Validator)MongoDbSinkConnectorConfig.emptyString().or(MongoDbSinkConnectorConfig.matching(FULLY_QUALIFIED_CLASS_NAME)), ConfigDef.Importance.HIGH, MONGODB_DOCUMENT_ID_STRATEGY_CONF_DOC).define(MONGODB_DOCUMENT_ID_STRATEGIES_CONF, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)MongoDbSinkConnectorConfig.emptyString().or(MongoDbSinkConnectorConfig.matching(FULLY_QUALIFIED_CLASS_NAME_LIST)), ConfigDef.Importance.LOW, MONGODB_DOCUMENT_ID_STRATEGIES_CONF_DOC).define(MONGODB_KEY_PROJECTION_TYPE_CONF, ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)EnumValidator.in(FieldProjectionTypes.values()), ConfigDef.Importance.LOW, MONGODB_KEY_PROJECTION_TYPE_DOC).define(MONGODB_KEY_PROJECTION_LIST_CONF, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, MONGODB_KEY_PROJECTION_LIST_DOC).define(MONGODB_FIELD_RENAMER_MAPPING, ConfigDef.Type.STRING, (Object)"[]", ConfigDef.Importance.LOW, MONGODB_FIELD_RENAMER_MAPPING_DOC).define(MONGODB_FIELD_RENAMER_REGEXP, ConfigDef.Type.STRING, (Object)"[]", ConfigDef.Importance.LOW, MONGODB_FIELD_RENAMER_REGEXP_DOC).define(MONGODB_POST_PROCESSOR_CHAIN, ConfigDef.Type.STRING, (Object)MONGODB_POST_PROCESSOR_CHAIN_DEFAULT, (ConfigDef.Validator)MongoDbSinkConnectorConfig.emptyString().or(MongoDbSinkConnectorConfig.matching(FULLY_QUALIFIED_CLASS_NAME_LIST)), ConfigDef.Importance.LOW, MONGODB_POST_PROCESSOR_CHAIN_DOC).define(MONGODB_CHANGE_DATA_CAPTURE_HANDLER, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)MongoDbSinkConnectorConfig.emptyString().or(MongoDbSinkConnectorConfig.matching(FULLY_QUALIFIED_CLASS_NAME)), ConfigDef.Importance.LOW, MONGODB_CHANGE_DATA_CAPTURE_HANDLER_DOC).define(MONGODB_CHANGE_DATA_CAPTURE_HANDLER_OPERATIONS, ConfigDef.Type.STRING, (Object)MONGODB_CHANGE_DATA_CAPTURE_HANDLER_OPERATIONS_DEFAULT, ConfigDef.Importance.LOW, MONGODB_CHANGE_DATA_CAPTURE_HANDLER_OPERATIONS_DOC).define(MONGODB_DELETE_ON_NULL_VALUES, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, MONGODB_DELETE_ON_NULL_VALUES_DOC).define(MONGODB_WRITEMODEL_STRATEGY, ConfigDef.Type.STRING, (Object)MONGODB_WRITEMODEL_STRATEGY_DEFAULT, ConfigDef.Importance.LOW, MONGODB_WRITEMODEL_STRATEGY_DOC).define(MONGODB_MAX_BATCH_SIZE, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MONGODB_MAX_BATCH_SIZE_DOC).define(MONGODB_RATE_LIMITING_TIMEOUT, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, MONGODB_RATE_LIMITING_TIMEOUT_DOC).define(MONGODB_RATE_LIMITING_EVERY_N, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, MONGODB_RATE_LIMITING_EVERY_N_DOC);
    }

    public MongoClientURI buildClientURI() {
        return new MongoClientURI(this.getString(MONGODB_CONNECTION_URI_CONF));
    }

    @Deprecated
    public boolean isUsingBlacklistValueProjection() {
        return this.isUsingBlacklistValueProjection("");
    }

    public boolean isUsingBlacklistValueProjection(String collection) {
        return this.getString(MONGODB_VALUE_PROJECTION_TYPE_CONF, collection).equalsIgnoreCase(FieldProjectionTypes.BLACKLIST.name());
    }

    @Deprecated
    public boolean isUsingWhitelistValueProjection() {
        return this.isUsingWhitelistValueProjection("");
    }

    public boolean isUsingWhitelistValueProjection(String collection) {
        return this.getString(MONGODB_VALUE_PROJECTION_TYPE_CONF, collection).equalsIgnoreCase(FieldProjectionTypes.WHITELIST.name());
    }

    @Deprecated
    public boolean isUsingBlacklistKeyProjection() {
        return this.isUsingBlacklistKeyProjection("");
    }

    public boolean isUsingBlacklistKeyProjection(String collection) {
        return this.getString(MONGODB_KEY_PROJECTION_TYPE_CONF, collection).equalsIgnoreCase(FieldProjectionTypes.BLACKLIST.name());
    }

    @Deprecated
    public boolean isUsingWhitelistKeyProjection() {
        return this.isUsingWhitelistKeyProjection("");
    }

    public boolean isUsingWhitelistKeyProjection(String collection) {
        return this.getString(MONGODB_KEY_PROJECTION_TYPE_CONF, collection).equalsIgnoreCase(FieldProjectionTypes.WHITELIST.name());
    }

    @Deprecated
    public Set<String> getKeyProjectionList() {
        return this.getKeyProjectionList("");
    }

    public Set<String> getKeyProjectionList(String collection) {
        return this.buildProjectionList(this.getString(MONGODB_KEY_PROJECTION_TYPE_CONF, collection), this.getString(MONGODB_KEY_PROJECTION_LIST_CONF, collection));
    }

    @Deprecated
    public Set<String> getValueProjectionList() {
        return this.getValueProjectionList("");
    }

    public Set<String> getValueProjectionList(String collection) {
        return this.buildProjectionList(this.getString(MONGODB_VALUE_PROJECTION_TYPE_CONF, collection), this.getString(MONGODB_VALUE_PROJECTION_LIST_CONF, collection));
    }

    @Deprecated
    public Map<String, String> parseRenameFieldnameMappings() {
        return this.parseRenameFieldnameMappings("");
    }

    public Map<String, String> parseRenameFieldnameMappings(String collection) {
        try {
            String settings = this.getString(MONGODB_FIELD_RENAMER_MAPPING, collection);
            if (settings.isEmpty()) {
                return new HashMap<String, String>();
            }
            List fm = (List)objectMapper.readValue(settings, (TypeReference)new TypeReference<List<FieldnameMapping>>(){});
            HashMap<String, String> map = new HashMap<String, String>();
            for (FieldnameMapping e : fm) {
                map.put(e.oldName, e.newName);
            }
            return map;
        }
        catch (IOException e) {
            throw new ConfigException("error: parsing rename fieldname mappings failed", (Object)e);
        }
    }

    @Deprecated
    public Map<String, RenameByRegExp.PatternReplace> parseRenameRegExpSettings() {
        return this.parseRenameRegExpSettings("");
    }

    public Map<String, RenameByRegExp.PatternReplace> parseRenameRegExpSettings(String collection) {
        try {
            String settings = this.getString(MONGODB_FIELD_RENAMER_REGEXP, collection);
            if (settings.isEmpty()) {
                return new HashMap<String, RenameByRegExp.PatternReplace>();
            }
            List fm = (List)objectMapper.readValue(settings, (TypeReference)new TypeReference<List<RegExpSettings>>(){});
            HashMap<String, RenameByRegExp.PatternReplace> map = new HashMap<String, RenameByRegExp.PatternReplace>();
            for (RegExpSettings e : fm) {
                map.put(e.regexp, new RenameByRegExp.PatternReplace(e.pattern, e.replace));
            }
            return map;
        }
        catch (IOException e) {
            throw new ConfigException("error: parsing rename regexp settings failed", (Object)e);
        }
    }

    @Deprecated
    public PostProcessor buildPostProcessorChain() {
        return this.buildPostProcessorChain("");
    }

    public PostProcessor buildPostProcessorChain(String collection) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>(this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_POST_PROCESSOR_CHAIN, collection)));
        if (classes.size() == 0) {
            return new DocumentIdAdder(this, collection);
        }
        PostProcessor first = null;
        if (!classes.contains(DocumentIdAdder.class.getName())) {
            first = new DocumentIdAdder(this, collection);
        }
        PostProcessor next = null;
        for (String clazz : classes) {
            try {
                if (first == null) {
                    first = (PostProcessor)Class.forName(clazz).getConstructor(MongoDbSinkConnectorConfig.class, String.class).newInstance(new Object[]{this, collection});
                    continue;
                }
                PostProcessor current = (PostProcessor)Class.forName(clazz).getConstructor(MongoDbSinkConnectorConfig.class, String.class).newInstance(new Object[]{this, collection});
                if (next == null) {
                    first.chain(current);
                    next = current;
                    continue;
                }
                next = next.chain(current);
            }
            catch (ReflectiveOperationException e) {
                throw new ConfigException(e.getMessage(), (Object)e);
            }
            catch (ClassCastException e) {
                throw new ConfigException("error: specified class " + clazz + " violates the contract since it doesn't extend " + PostProcessor.class.getName());
            }
        }
        return first;
    }

    public Map<String, PostProcessor> buildPostProcessorChains() {
        HashMap<String, PostProcessor> postProcessorChains = new HashMap<String, PostProcessor>();
        postProcessorChains.put(TOPIC_AGNOSTIC_KEY_NAME, this.buildPostProcessorChain(""));
        this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_COLLECTIONS_CONF)).forEach(collection -> postProcessorChains.put((String)collection, this.buildPostProcessorChain((String)collection)));
        return postProcessorChains;
    }

    private Set<String> buildProjectionList(String projectionType, String fieldList) {
        if (projectionType.equalsIgnoreCase(FieldProjectionTypes.NONE.name())) {
            return new HashSet<String>();
        }
        if (projectionType.equalsIgnoreCase(FieldProjectionTypes.BLACKLIST.name())) {
            return new HashSet<String>(this.splitAndTrimAndRemoveConfigListEntries(fieldList));
        }
        if (projectionType.equalsIgnoreCase(FieldProjectionTypes.WHITELIST.name())) {
            HashSet<String> whitelistExpanded = new HashSet<String>();
            List<String> fields = this.splitAndTrimAndRemoveConfigListEntries(fieldList);
            for (String f : fields) {
                if (!f.contains(MONGODB_NAMESPACE_SEPARATOR)) {
                    whitelistExpanded.add(f);
                    continue;
                }
                String[] parts = f.split("\\.");
                String entry = parts[0];
                whitelistExpanded.add(entry);
                for (int s = 1; s < parts.length; ++s) {
                    entry = entry + MONGODB_NAMESPACE_SEPARATOR + parts[s];
                    whitelistExpanded.add(entry);
                }
            }
            return whitelistExpanded;
        }
        throw new ConfigException("error: invalid settings for " + projectionType);
    }

    private List<String> splitAndTrimAndRemoveConfigListEntries(String entries) {
        return Arrays.stream(entries.trim().split(FIELD_LIST_SPLIT_EXPR)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Deprecated
    public boolean isUsingCdcHandler() {
        return this.isUsingCdcHandler("");
    }

    public boolean isUsingCdcHandler(String collection) {
        return !this.getString(MONGODB_CHANGE_DATA_CAPTURE_HANDLER, collection).isEmpty();
    }

    @Deprecated
    public boolean isDeleteOnNullValues() {
        return this.isDeleteOnNullValues("");
    }

    public boolean isDeleteOnNullValues(String collection) {
        return this.getBoolean(MONGODB_DELETE_ON_NULL_VALUES, collection);
    }

    @Deprecated
    public WriteModelStrategy getWriteModelStrategy() {
        return this.getWriteModelStrategy("");
    }

    public WriteModelStrategy getWriteModelStrategy(String collection) {
        String strategyClassName = this.getString(MONGODB_WRITEMODEL_STRATEGY, collection);
        try {
            return (WriteModelStrategy)Class.forName(strategyClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigException(e.getMessage(), (Object)e);
        }
        catch (ClassCastException e) {
            throw new ConfigException("error: specified class " + strategyClassName + " violates the contract since it doesn't implement " + WriteModelStrategy.class);
        }
    }

    public Map<String, WriteModelStrategy> getWriteModelStrategies() {
        HashMap<String, WriteModelStrategy> writeModelStrategies = new HashMap<String, WriteModelStrategy>();
        writeModelStrategies.put(TOPIC_AGNOSTIC_KEY_NAME, this.getWriteModelStrategy(""));
        this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_COLLECTIONS_CONF)).forEach(collection -> writeModelStrategies.put((String)collection, this.getWriteModelStrategy((String)collection)));
        return writeModelStrategies;
    }

    public RateLimitSettings getRateLimitSettings(String collection) {
        return new RateLimitSettings(this.getInt(MONGODB_RATE_LIMITING_TIMEOUT, collection), this.getInt(MONGODB_RATE_LIMITING_EVERY_N, collection));
    }

    public Map<String, RateLimitSettings> getRateLimitSettings() {
        HashMap<String, RateLimitSettings> rateLimitSettings = new HashMap<String, RateLimitSettings>();
        rateLimitSettings.put(TOPIC_AGNOSTIC_KEY_NAME, this.getRateLimitSettings(""));
        this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_COLLECTIONS_CONF)).forEach(collection -> rateLimitSettings.put((String)collection, this.getRateLimitSettings((String)collection)));
        return rateLimitSettings;
    }

    public WriteModelStrategy getDeleteOneModelDefaultStrategy(String collection) {
        IdStrategy idStrategy = this.getIdStrategy(collection);
        if (!(idStrategy instanceof FullKeyStrategy || idStrategy instanceof PartialKeyStrategy || idStrategy instanceof ProvidedInKeyStrategy)) {
            throw new ConfigException(DeleteOneDefaultStrategy.class.getName() + " can only be applied when the configured IdStrategy is either " + FullKeyStrategy.class.getSimpleName() + " or " + PartialKeyStrategy.class.getSimpleName() + " or " + ProvidedInKeyStrategy.class.getSimpleName());
        }
        return new DeleteOneDefaultStrategy(idStrategy);
    }

    public Map<String, WriteModelStrategy> getDeleteOneModelDefaultStrategies() {
        HashMap<String, WriteModelStrategy> deleteModelStrategies = new HashMap<String, WriteModelStrategy>();
        if (this.isDeleteOnNullValues("")) {
            deleteModelStrategies.put(TOPIC_AGNOSTIC_KEY_NAME, this.getDeleteOneModelDefaultStrategy(""));
        }
        this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_COLLECTIONS_CONF)).forEach(collection -> {
            if (this.isDeleteOnNullValues((String)collection)) {
                deleteModelStrategies.put((String)collection, this.getDeleteOneModelDefaultStrategy((String)collection));
            }
        });
        return deleteModelStrategies;
    }

    public static Set<String> getPredefinedCdcHandlerClassNames() {
        HashSet<String> cdcHandlers = new HashSet<String>();
        cdcHandlers.add(MongoDbHandler.class.getName());
        cdcHandlers.add(RdbmsHandler.class.getName());
        cdcHandlers.add(MysqlHandler.class.getName());
        cdcHandlers.add(PostgresHandler.class.getName());
        return cdcHandlers;
    }

    @Deprecated
    public CdcHandler getCdcHandler() {
        return this.getCdcHandler("");
    }

    public CdcHandler getCdcHandler(String collection) {
        Set<String> predefinedCdcHandler = MongoDbSinkConnectorConfig.getPredefinedCdcHandlerClassNames();
        String cdcHandler = this.getString(MONGODB_CHANGE_DATA_CAPTURE_HANDLER, collection);
        if (cdcHandler.isEmpty()) {
            return null;
        }
        if (!predefinedCdcHandler.contains(cdcHandler)) {
            throw new ConfigException("error: unknown cdc handler " + cdcHandler);
        }
        List supportedOperations = new HashSet<String>(this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_CHANGE_DATA_CAPTURE_HANDLER_OPERATIONS, collection))).stream().map(OperationType::fromText).collect(Collectors.toList());
        try {
            Class<?> cdcHandlerClass = Class.forName(cdcHandler);
            return (CdcHandler)cdcHandlerClass.getConstructor(MongoDbSinkConnectorConfig.class, List.class).newInstance(new Object[]{this, supportedOperations});
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigException(e.getMessage(), (Object)e);
        }
        catch (ClassCastException e) {
            throw new ConfigException("error: specified class " + cdcHandler + " violates the contract since it doesn't implement " + CdcHandler.class);
        }
    }

    public Map<String, CdcHandler> getCdcHandlers() {
        HashMap<String, CdcHandler> cdcHandlers = new HashMap<String, CdcHandler>();
        if (this.isUsingCdcHandler("")) {
            cdcHandlers.put(TOPIC_AGNOSTIC_KEY_NAME, this.getCdcHandler(""));
        }
        this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_COLLECTIONS_CONF)).forEach(collection -> {
            CdcHandler candidate = cdcHandlers.put((String)collection, this.getCdcHandler((String)collection));
            if (candidate != null) {
                cdcHandlers.put((String)collection, candidate);
            }
        });
        return cdcHandlers;
    }

    public static Set<String> getPredefinedIdStrategyClassNames() {
        HashSet<String> strategies = new HashSet<String>();
        strategies.add(BsonOidStrategy.class.getName());
        strategies.add(FullKeyStrategy.class.getName());
        strategies.add(KafkaMetaDataStrategy.class.getName());
        strategies.add(PartialKeyStrategy.class.getName());
        strategies.add(PartialValueStrategy.class.getName());
        strategies.add(ProvidedInKeyStrategy.class.getName());
        strategies.add(ProvidedInValueStrategy.class.getName());
        strategies.add(UuidStrategy.class.getName());
        return strategies;
    }

    @Deprecated
    public IdStrategy getIdStrategy() {
        return this.getIdStrategy("");
    }

    public IdStrategy getIdStrategy(String collection) {
        Set<String> availableIdStrategies = MongoDbSinkConnectorConfig.getPredefinedIdStrategyClassNames();
        HashSet<String> customIdStrategies = new HashSet<String>(this.splitAndTrimAndRemoveConfigListEntries(this.getString(MONGODB_DOCUMENT_ID_STRATEGIES_CONF)));
        availableIdStrategies.addAll(customIdStrategies);
        String strategyClassName = this.getString(MONGODB_DOCUMENT_ID_STRATEGY_CONF, collection);
        if (!availableIdStrategies.contains(strategyClassName)) {
            throw new ConfigException("error: unknown id strategy " + strategyClassName);
        }
        try {
            if (strategyClassName.equals(PartialKeyStrategy.class.getName()) || strategyClassName.equals(PartialValueStrategy.class.getName())) {
                return (IdStrategy)Class.forName(strategyClassName).getConstructor(FieldProjector.class).newInstance(this.getKeyProjector(collection));
            }
            return (IdStrategy)Class.forName(strategyClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigException(e.getMessage(), (Object)e);
        }
        catch (ClassCastException e) {
            throw new ConfigException("error: specified class " + strategyClassName + " violates the contract since it doesn't implement " + IdStrategy.class);
        }
    }

    @Deprecated
    public FieldProjector getKeyProjector() {
        return this.getKeyProjector("");
    }

    public FieldProjector getKeyProjector(String collection) {
        if (this.getString(MONGODB_KEY_PROJECTION_TYPE_CONF, collection).equalsIgnoreCase(FieldProjectionTypes.BLACKLIST.name())) {
            if (this.getString(MONGODB_DOCUMENT_ID_STRATEGY_CONF, collection).equals(PartialValueStrategy.class.getName())) {
                return new BlacklistValueProjector(this, this.getKeyProjectionList(collection), cfg -> cfg.isUsingBlacklistKeyProjection(collection), collection);
            }
            if (this.getString(MONGODB_DOCUMENT_ID_STRATEGY_CONF, collection).equals(PartialKeyStrategy.class.getName())) {
                return new BlacklistKeyProjector(this, this.getKeyProjectionList(collection), cfg -> cfg.isUsingBlacklistKeyProjection(collection), collection);
            }
        }
        if (this.getString(MONGODB_KEY_PROJECTION_TYPE_CONF, collection).equalsIgnoreCase(FieldProjectionTypes.WHITELIST.name())) {
            if (this.getString(MONGODB_DOCUMENT_ID_STRATEGY_CONF, collection).equals(PartialValueStrategy.class.getName())) {
                return new WhitelistValueProjector(this, this.getKeyProjectionList(collection), cfg -> cfg.isUsingWhitelistKeyProjection(collection), collection);
            }
            if (this.getString(MONGODB_DOCUMENT_ID_STRATEGY_CONF, collection).equals(PartialKeyStrategy.class.getName())) {
                return new WhitelistKeyProjector(this, this.getKeyProjectionList(collection), cfg -> cfg.isUsingWhitelistKeyProjection(collection), collection);
            }
        }
        throw new ConfigException("error: settings invalid for mongodb.key.projection.type");
    }

    protected static ValidatorWithOperators emptyString() {
        return (name, value) -> {
            if (!((String)value).isEmpty()) {
                throw new ConfigException(name, value, "Not empty");
            }
        };
    }

    protected static ValidatorWithOperators matching(Pattern pattern) {
        return (name, value) -> {
            if (!pattern.matcher((String)value).matches()) {
                throw new ConfigException(name, value, "Does not match: " + pattern);
            }
        };
    }

    static interface ValidatorWithOperators
    extends ConfigDef.Validator {
        default public ValidatorWithOperators or(ConfigDef.Validator other) {
            return (name, value) -> {
                try {
                    this.ensureValid(name, value);
                }
                catch (ConfigException e) {
                    other.ensureValid(name, value);
                }
            };
        }

        default public ValidatorWithOperators and(ConfigDef.Validator other) {
            return (name, value) -> {
                this.ensureValid(name, value);
                other.ensureValid(name, value);
            };
        }
    }

    private static class EnumValidator
    implements ConfigDef.Validator {
        private final List<String> canonicalValues;
        private final Set<String> validValues;

        private EnumValidator(List<String> canonicalValues, Set<String> validValues) {
            this.canonicalValues = canonicalValues;
            this.validValues = validValues;
        }

        public static <E> EnumValidator in(E[] enumerators) {
            ArrayList<String> canonicalValues = new ArrayList<String>(enumerators.length);
            HashSet<String> validValues = new HashSet<String>(enumerators.length * 2);
            for (E e : enumerators) {
                canonicalValues.add(e.toString().toLowerCase());
                validValues.add(e.toString().toUpperCase());
                validValues.add(e.toString().toLowerCase());
            }
            return new EnumValidator(canonicalValues, validValues);
        }

        public void ensureValid(String key, Object value) {
            if (!this.validValues.contains(value)) {
                throw new ConfigException(key, value, "Invalid enumerator");
            }
        }

        public String toString() {
            return this.canonicalValues.toString();
        }
    }

    public static class RateLimitSettings {
        private final int timeoutMs;
        private final int everyN;
        private long counter;

        public RateLimitSettings(int timeoutMs, int everyN) {
            this.timeoutMs = timeoutMs;
            this.everyN = everyN;
        }

        public boolean isTriggered() {
            ++this.counter;
            return this.everyN != 0 && this.counter >= (long)this.everyN && this.counter % (long)this.everyN == 0L;
        }

        public int getTimeoutMs() {
            return this.timeoutMs;
        }

        public int getEveryN() {
            return this.everyN;
        }

        public long getCounter() {
            return this.counter;
        }
    }

    public static enum FieldProjectionTypes {
        NONE,
        BLACKLIST,
        WHITELIST;

    }
}

