/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.sink.SinkRecord;

public class MongoDbSinkRecordBatches {
    private int batchSize;
    private int currentBatch = 0;
    private List<List<SinkRecord>> bufferedBatches = new ArrayList<List<SinkRecord>>();

    public MongoDbSinkRecordBatches(int batchSize, int records) {
        this.batchSize = batchSize;
        this.bufferedBatches.add(batchSize > 0 ? new ArrayList(batchSize) : new ArrayList(records));
    }

    public void buffer(SinkRecord record) {
        if (this.batchSize > 0) {
            if (this.bufferedBatches.get(this.currentBatch).size() < this.batchSize) {
                this.bufferedBatches.get(this.currentBatch).add(record);
            } else {
                this.bufferedBatches.add(new ArrayList(this.batchSize));
                this.bufferedBatches.get(++this.currentBatch).add(record);
            }
        } else {
            this.bufferedBatches.get(0).add(record);
        }
    }

    public List<List<SinkRecord>> getBufferedBatches() {
        return this.bufferedBatches;
    }
}

