/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms;

import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.OperationType;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsHandler;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.WriteModel;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class RdbmsDelete
implements CdcOperation {
    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("error: key doc must not be missing for delete operation"));
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("error: value doc must not be missing for delete operation"));
        try {
            BsonDocument filterDoc = RdbmsHandler.generateFilterDoc(keyDoc, valueDoc, OperationType.DELETE);
            return new DeleteOneModel((Bson)filterDoc);
        }
        catch (Exception exc) {
            throw new DataException((Throwable)exc);
        }
    }
}

