/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.DebeziumCdcHandler;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.OperationType;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsDelete;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsInsert;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsNoOp;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.RdbmsUpdate;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import com.mongodb.client.model.WriteModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsHandler
extends DebeziumCdcHandler {
    public static final String JSON_DOC_BEFORE_FIELD = "before";
    public static final String JSON_DOC_AFTER_FIELD = "after";
    private static Logger logger = LoggerFactory.getLogger(RdbmsHandler.class);

    public RdbmsHandler(MongoDbSinkConnectorConfig config) {
        super(config);
        HashMap<OperationType, CdcOperation> operations = new HashMap<OperationType, CdcOperation>();
        operations.put(OperationType.CREATE, new RdbmsInsert());
        operations.put(OperationType.READ, new RdbmsInsert());
        operations.put(OperationType.UPDATE, new RdbmsUpdate());
        operations.put(OperationType.DELETE, new RdbmsDelete());
        this.registerOperations(operations);
    }

    public RdbmsHandler(MongoDbSinkConnectorConfig config, Map<OperationType, CdcOperation> operations) {
        super(config);
        this.registerOperations(operations);
    }

    public RdbmsHandler(MongoDbSinkConnectorConfig config, List<OperationType> supportedTypes) {
        super(config);
        HashMap<OperationType, CdcOperation> operations = new HashMap<OperationType, CdcOperation>();
        Stream.of(OperationType.values()).forEach(ot -> {
            CdcOperation cfr_ignored_0 = operations.put((OperationType)((Object)ot), new RdbmsNoOp());
        });
        supportedTypes.forEach(ot -> {
            switch (ot) {
                case CREATE: 
                case READ: {
                    operations.put((OperationType)((Object)ot), new RdbmsInsert());
                    break;
                }
                case UPDATE: {
                    operations.put((OperationType)((Object)ot), new RdbmsUpdate());
                    break;
                }
                case DELETE: {
                    operations.put((OperationType)((Object)ot), new RdbmsDelete());
                }
            }
        });
        this.registerOperations(operations);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseGet(BsonDocument::new);
        BsonDocument valueDoc = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (valueDoc.isEmpty()) {
            logger.debug("skipping debezium tombstone event for kafka topic compaction");
            return Optional.empty();
        }
        return Optional.ofNullable(this.getCdcOperation(valueDoc).perform(new SinkDocument(keyDoc, valueDoc)));
    }

    protected static BsonDocument generateFilterDoc(BsonDocument keyDoc, BsonDocument valueDoc, OperationType opType) {
        if (keyDoc.keySet().isEmpty()) {
            if (opType.equals((Object)OperationType.CREATE) || opType.equals((Object)OperationType.READ)) {
                return new BsonDocument("_id", (BsonValue)new BsonObjectId());
            }
            try {
                BsonDocument filter = valueDoc.getDocument((Object)JSON_DOC_BEFORE_FIELD);
                if (filter.isEmpty()) {
                    throw new BsonInvalidOperationException("value doc before field is empty");
                }
                return filter;
            }
            catch (BsonInvalidOperationException exc) {
                throw new DataException("error: value doc 'before' field is empty or has invalid type for update/delete operation which seems severely wrong -> defensive actions taken!", (Throwable)exc);
            }
        }
        BsonDocument pk = new BsonDocument();
        for (String f : keyDoc.keySet()) {
            pk.put(f, keyDoc.get((Object)f));
        }
        return new BsonDocument("_id", (BsonValue)pk);
    }

    protected static BsonDocument generateUpsertOrReplaceDoc(BsonDocument keyDoc, BsonDocument valueDoc, BsonDocument filterDoc) {
        if (!valueDoc.containsKey((Object)JSON_DOC_AFTER_FIELD) || valueDoc.get((Object)JSON_DOC_AFTER_FIELD).isNull() || !valueDoc.get((Object)JSON_DOC_AFTER_FIELD).isDocument() || valueDoc.getDocument((Object)JSON_DOC_AFTER_FIELD).isEmpty()) {
            throw new DataException("error: valueDoc must contain non-empty 'after' field of type document for insert/update operation");
        }
        BsonDocument upsertDoc = new BsonDocument();
        if (filterDoc.containsKey((Object)"_id")) {
            upsertDoc.put("_id", filterDoc.get((Object)"_id"));
        }
        BsonDocument afterDoc = valueDoc.getDocument((Object)JSON_DOC_AFTER_FIELD);
        for (String f : afterDoc.keySet()) {
            if (keyDoc.containsKey((Object)f)) continue;
            upsertDoc.put(f, afterDoc.get((Object)f));
        }
        return upsertDoc;
    }
}

