/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.outbox;

import at.grahsl.kafka.connect.mongodb.cdc.CdcOperation;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.OperationType;
import at.grahsl.kafka.connect.mongodb.cdc.debezium.rdbms.outbox.OutboxHandler;
import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class OutboxInsert
implements CdcOperation {
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("error: key doc must not be missing for insert operation"));
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("error: value doc must not be missing for insert operation"));
        try {
            BsonDocument filterDoc = OutboxHandler.generateFilterDoc(keyDoc, valueDoc, OperationType.CREATE);
            BsonDocument upsertDoc = OutboxHandler.generateUpsertOrReplaceDoc(keyDoc, valueDoc, filterDoc);
            return new ReplaceOneModel((Bson)filterDoc, (Object)upsertDoc, UPDATE_OPTIONS);
        }
        catch (Exception exc) {
            throw new DataException((Throwable)exc);
        }
    }
}

