/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.converter;

import at.grahsl.kafka.connect.mongodb.converter.RecordConverter;
import at.grahsl.kafka.connect.mongodb.converter.SinkFieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.BooleanFieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.BytesFieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.Float32FieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.Float64FieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.Int16FieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.Int32FieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.Int64FieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.Int8FieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.StringFieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.logical.DateFieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.logical.DecimalFieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.logical.TimeFieldConverter;
import at.grahsl.kafka.connect.mongodb.converter.types.sink.bson.logical.TimestampFieldConverter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroJsonSchemafulRecordConverter
implements RecordConverter {
    public static final Set<String> LOGICAL_TYPE_NAMES = new HashSet<String>(Arrays.asList("org.apache.kafka.connect.data.Date", "org.apache.kafka.connect.data.Decimal", "org.apache.kafka.connect.data.Time", "org.apache.kafka.connect.data.Timestamp"));
    private final Map<Schema.Type, SinkFieldConverter> converters = new HashMap<Schema.Type, SinkFieldConverter>();
    private final Map<String, SinkFieldConverter> logicalConverters = new HashMap<String, SinkFieldConverter>();
    private static Logger logger = LoggerFactory.getLogger(AvroJsonSchemafulRecordConverter.class);

    public AvroJsonSchemafulRecordConverter() {
        this.registerSinkFieldConverter(new BooleanFieldConverter());
        this.registerSinkFieldConverter(new Int8FieldConverter());
        this.registerSinkFieldConverter(new Int16FieldConverter());
        this.registerSinkFieldConverter(new Int32FieldConverter());
        this.registerSinkFieldConverter(new Int64FieldConverter());
        this.registerSinkFieldConverter(new Float32FieldConverter());
        this.registerSinkFieldConverter(new Float64FieldConverter());
        this.registerSinkFieldConverter(new StringFieldConverter());
        this.registerSinkFieldConverter(new BytesFieldConverter());
        this.registerSinkFieldLogicalConverter(new DateFieldConverter());
        this.registerSinkFieldLogicalConverter(new TimeFieldConverter());
        this.registerSinkFieldLogicalConverter(new TimestampFieldConverter());
        this.registerSinkFieldLogicalConverter(new DecimalFieldConverter());
    }

    @Override
    public BsonDocument convert(Schema schema, Object value) {
        if (schema == null || value == null) {
            throw new DataException("error: schema and/or value was null for AVRO conversion");
        }
        return this.toBsonDoc(schema, value);
    }

    private void registerSinkFieldConverter(SinkFieldConverter converter) {
        this.converters.put(converter.getSchema().type(), converter);
    }

    private void registerSinkFieldLogicalConverter(SinkFieldConverter converter) {
        this.logicalConverters.put(converter.getSchema().name(), converter);
    }

    private BsonDocument toBsonDoc(Schema schema, Object value) {
        BsonDocument doc = new BsonDocument();
        schema.fields().forEach(f -> this.processField(doc, (Struct)value, (Field)f));
        return doc;
    }

    private void processField(BsonDocument doc, Struct struct, Field field) {
        logger.trace("processing field '{}'", (Object)field.name());
        if (this.isSupportedLogicalType(field.schema())) {
            doc.put(field.name(), this.getConverter(field.schema()).toBson(struct.get(field), field.schema()));
            return;
        }
        try {
            switch (field.schema().type()) {
                case BOOLEAN: 
                case FLOAT32: 
                case FLOAT64: 
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case STRING: 
                case BYTES: {
                    this.handlePrimitiveField(doc, struct.get(field), field);
                    break;
                }
                case STRUCT: {
                    this.handleStructField(doc, (Struct)struct.get(field), field);
                    break;
                }
                case ARRAY: {
                    doc.put(field.name(), this.handleArrayField((List)struct.get(field), field));
                    break;
                }
                case MAP: {
                    this.handleMapField(doc, (Map)struct.get(field), field);
                    break;
                }
                default: {
                    logger.error("Invalid schema. unexpected / unsupported schema type '" + field.schema().type() + "' for field '" + field.name() + "' value='" + struct + "'");
                    throw new DataException("unexpected / unsupported schema type " + field.schema().type());
                }
            }
        }
        catch (Exception exc) {
            logger.error("Error while processing field. schema type '" + field.schema().type() + "' for field '" + field.name() + "' value='" + struct + "'");
            throw new DataException("error while processing field " + field.name(), (Throwable)exc);
        }
    }

    private void handleMapField(BsonDocument doc, Map m, Field field) {
        logger.trace("handling complex type 'map'");
        if (m == null) {
            logger.trace("no field in struct -> adding null");
            doc.put(field.name(), (BsonValue)BsonNull.VALUE);
            return;
        }
        BsonDocument bd = new BsonDocument();
        for (Object entry : m.keySet()) {
            String key = (String)entry;
            Schema.Type valueSchemaType = field.schema().valueSchema().type();
            if (valueSchemaType.isPrimitive()) {
                bd.put(key, this.getConverter(field.schema().valueSchema()).toBson(m.get(key), field.schema()));
                continue;
            }
            if (valueSchemaType.equals((Object)Schema.Type.ARRAY)) {
                Field elementField = new Field(key, 0, field.schema().valueSchema());
                List list = (List)m.get(key);
                logger.trace("adding array values to {} of type valueSchema={} value='{}'", new Object[]{elementField.name(), elementField.schema().valueSchema(), list});
                bd.put(key, this.handleArrayField(list, elementField));
                continue;
            }
            bd.put(key, (BsonValue)this.toBsonDoc(field.schema().valueSchema(), m.get(key)));
        }
        doc.put(field.name(), (BsonValue)bd);
    }

    private BsonValue handleArrayField(List list, Field field) {
        logger.trace("handling complex type 'array' of types '{}'", (Object)field.schema().valueSchema().type());
        if (list == null) {
            logger.trace("no array -> adding null");
            return BsonNull.VALUE;
        }
        BsonArray array = new BsonArray();
        Schema.Type st = field.schema().valueSchema().type();
        for (Object element : list) {
            if (st.isPrimitive()) {
                array.add(this.getConverter(field.schema().valueSchema()).toBson(element, field.schema()));
                continue;
            }
            if (st == Schema.Type.ARRAY) {
                Field elementField = new Field("first", 0, field.schema().valueSchema());
                array.add(this.handleArrayField((List)element, elementField));
                continue;
            }
            array.add((BsonValue)this.toBsonDoc(field.schema().valueSchema(), element));
        }
        return array;
    }

    private void handleStructField(BsonDocument doc, Struct struct, Field field) {
        logger.trace("handling complex type 'struct'");
        if (struct != null) {
            logger.trace(struct.toString());
            doc.put(field.name(), (BsonValue)this.toBsonDoc(field.schema(), struct));
        } else {
            logger.trace("no field in struct -> adding null");
            doc.put(field.name(), (BsonValue)BsonNull.VALUE);
        }
    }

    private void handlePrimitiveField(BsonDocument doc, Object value, Field field) {
        logger.trace("handling primitive type '{}' name='{}'", (Object)field.schema().type(), (Object)field.name());
        doc.put(field.name(), this.getConverter(field.schema()).toBson(value, field.schema()));
    }

    private boolean isSupportedLogicalType(Schema schema) {
        if (schema.name() == null) {
            return false;
        }
        return LOGICAL_TYPE_NAMES.contains(schema.name());
    }

    private SinkFieldConverter getConverter(Schema schema) {
        SinkFieldConverter converter = this.isSupportedLogicalType(schema) ? this.logicalConverters.get(schema.name()) : this.converters.get(schema.type());
        if (converter == null) {
            throw new ConnectException("error no registered converter found for " + schema.type().getName());
        }
        return converter;
    }
}

