/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.converter;

import at.grahsl.kafka.connect.mongodb.converter.FieldConverter;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SinkFieldConverter
extends FieldConverter {
    private static Logger logger = LoggerFactory.getLogger(SinkFieldConverter.class);

    public SinkFieldConverter(Schema schema) {
        super(schema);
    }

    public abstract BsonValue toBson(Object var1);

    public BsonValue toBson(Object data, Schema fieldSchema) {
        if (!fieldSchema.isOptional()) {
            if (data == null) {
                throw new DataException("error: schema not optional but data was null");
            }
            logger.trace("field not optional and data is '{}'", (Object)data.toString());
            return this.toBson(data);
        }
        if (data != null) {
            logger.trace("field optional and data is '{}'", (Object)data.toString());
            return this.toBson(data);
        }
        if (fieldSchema.defaultValue() != null) {
            logger.trace("field optional and no data but default value is '{}'", (Object)fieldSchema.defaultValue().toString());
            return this.toBson(fieldSchema.defaultValue());
        }
        logger.trace("field optional, no data and no default value thus '{}'", (Object)BsonNull.VALUE);
        return BsonNull.VALUE;
    }
}

