/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor.field.projection;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.processor.field.projection.FieldProjector;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class BlacklistProjector
extends FieldProjector {
    public BlacklistProjector(MongoDbSinkConnectorConfig config, String collection) {
        this(config, config.getValueProjectionList(collection), collection);
    }

    public BlacklistProjector(MongoDbSinkConnectorConfig config, Set<String> fields, String collection) {
        super(config, collection);
        this.fields = fields;
    }

    @Override
    protected void doProjection(String field, BsonDocument doc) {
        String otherParts;
        if (!field.contains(".")) {
            if (field.equals("*") || field.equals("**")) {
                this.handleWildcard(field, "", doc);
                return;
            }
            if (!field.equals("_id")) {
                doc.remove((Object)field);
            }
            return;
        }
        int dotIdx = field.indexOf(".");
        String firstPart = field.substring(0, dotIdx);
        String string = otherParts = field.length() >= dotIdx ? field.substring(dotIdx + 1) : "";
        if (firstPart.equals("*") || firstPart.equals("**")) {
            this.handleWildcard(firstPart, otherParts, doc);
            return;
        }
        BsonValue value = doc.get((Object)firstPart);
        if (value != null) {
            if (value.isDocument()) {
                this.doProjection(otherParts, (BsonDocument)value);
            }
            if (value.isArray()) {
                BsonArray values = (BsonArray)value;
                for (BsonValue v : values.getValues()) {
                    if (v == null || !v.isDocument()) continue;
                    this.doProjection(otherParts, (BsonDocument)v);
                }
            }
        }
    }

    private void handleWildcard(String firstPart, String otherParts, BsonDocument doc) {
        Iterator iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            BsonValue value = (BsonValue)entry.getValue();
            if (((String)entry.getKey()).equals("_id")) continue;
            if (firstPart.equals("**")) {
                iter.remove();
            }
            if (!firstPart.equals("*")) continue;
            if (!value.isDocument()) {
                iter.remove();
                continue;
            }
            if (otherParts.isEmpty()) continue;
            this.doProjection(otherParts, (BsonDocument)value);
        }
    }
}

