/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.processor.field.projection;

import at.grahsl.kafka.connect.mongodb.MongoDbSinkConnectorConfig;
import at.grahsl.kafka.connect.mongodb.processor.field.projection.FieldProjector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class WhitelistProjector
extends FieldProjector {
    public WhitelistProjector(MongoDbSinkConnectorConfig config, String collection) {
        this(config, config.getValueProjectionList(collection), collection);
    }

    public WhitelistProjector(MongoDbSinkConnectorConfig config, Set<String> fields, String collection) {
        super(config, collection);
        this.fields = fields;
    }

    @Override
    protected void doProjection(String field, BsonDocument doc) {
        if (this.fields.contains("**")) {
            return;
        }
        Iterator iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            String matchDoubleWildCard;
            Map.Entry entry = (Map.Entry)iter.next();
            String key = field.isEmpty() ? (String)entry.getKey() : field + "." + (String)entry.getKey();
            BsonValue value = (BsonValue)entry.getValue();
            if (!(this.fields.contains(key) || key.equals("_id") || this.checkForWildcardMatch(key))) {
                iter.remove();
            }
            if (value == null) continue;
            if (value.isDocument() && !this.fields.contains(matchDoubleWildCard = key + "." + "**")) {
                this.doProjection(key, (BsonDocument)value);
            }
            if (!value.isArray()) continue;
            BsonArray values = (BsonArray)value;
            for (BsonValue v : values.getValues()) {
                if (v == null || !v.isDocument()) continue;
                this.doProjection(key, (BsonDocument)v);
            }
        }
    }

    private boolean checkForWildcardMatch(String key) {
        String[] keyParts = key.split("\\.");
        Object[] pattern = new String[keyParts.length];
        Arrays.fill(pattern, "*");
        for (int c = (int)Math.pow(2.0, keyParts.length) - 1; c >= 0; --c) {
            int mask = 1;
            for (int d = keyParts.length - 1; d >= 0; --d) {
                if ((c & mask) != 0) {
                    pattern[d] = keyParts[d];
                }
                mask <<= 1;
            }
            if (this.fields.contains(String.join((CharSequence)".", (CharSequence[])pattern))) {
                return true;
            }
            Arrays.fill(pattern, "*");
        }
        return false;
    }
}

