/*
 * Decompiled with CFR 0.152.
 */
package at.grahsl.kafka.connect.mongodb.writemodel.strategy;

import at.grahsl.kafka.connect.mongodb.converter.SinkDocument;
import at.grahsl.kafka.connect.mongodb.writemodel.strategy.WriteModelStrategy;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.time.Instant;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class UpdateOneTimestampsStrategy
implements WriteModelStrategy {
    public static final String FIELDNAME_MODIFIED_TS = "_modifiedTS";
    public static final String FIELDNAME_INSERTED_TS = "_insertedTS";
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("error: cannot build the WriteModel since the value document was missing unexpectedly"));
        BsonDateTime dateTime = new BsonDateTime(Instant.now().toEpochMilli());
        return new UpdateOneModel((Bson)new BsonDocument("_id", vd.get((Object)"_id")), (Bson)new BsonDocument("$set", (BsonValue)vd.append(FIELDNAME_MODIFIED_TS, (BsonValue)dateTime)).append("$setOnInsert", (BsonValue)new BsonDocument(FIELDNAME_INSERTED_TS, (BsonValue)dateTime)), UPDATE_OPTIONS);
    }
}

