/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.backend.sesame;

import at.newmedialab.ldpath.backend.sesame.AbstractSesameBackend;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SesameConnectionBackend
extends AbstractSesameBackend {
    private final RepositoryConnection connection;
    private final ValueFactory valueFactory;

    public SesameConnectionBackend(RepositoryConnection connection) {
        this.connection = connection;
        this.valueFactory = connection.getValueFactory();
    }

    public Value createLiteral(String content) {
        return this.createLiteralInternal(this.valueFactory, content);
    }

    public Value createLiteral(String content, Locale language, URI type) {
        return this.createLiteralInternal(this.valueFactory, content, language, type);
    }

    public Value createURI(String uri) {
        return this.createURIInternal(this.valueFactory, uri);
    }

    public Collection<Value> listObjects(Value subject, Value property) {
        try {
            return this.listObjectsInternal(this.connection, (Resource)subject, (org.openrdf.model.URI)property);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("error while querying Sesame repository!", e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Subject needs to be a URI or blank node, property a URI node (types: [subject: %s, property: %s])", this.debugType(subject), this.debugType(property)), e);
        }
    }

    public Collection<Value> listSubjects(Value property, Value object) {
        try {
            return this.listSubjectsInternal(this.connection, (org.openrdf.model.URI)property, object);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("error while querying Sesame repository!", e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Property needs to be a URI node (property type: %s)", this.isURI(property) ? "URI" : (this.isBlank(property) ? "bNode" : "literal")), e);
        }
    }

    public static SesameConnectionBackend withConnection(RepositoryConnection connection) {
        return new SesameConnectionBackend(connection);
    }
}

