/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.functions.SelectorFunction;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import at.newmedialab.ldpath.api.transformers.NodeTransformer;
import at.newmedialab.ldpath.exception.LDPathParseException;
import at.newmedialab.ldpath.model.fields.FieldMapping;
import at.newmedialab.ldpath.model.programs.Program;
import at.newmedialab.ldpath.parser.Configuration;
import at.newmedialab.ldpath.parser.DefaultConfiguration;
import at.newmedialab.ldpath.parser.ParseException;
import at.newmedialab.ldpath.parser.RdfPathParser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LDPath<Node> {
    private RDFBackend<Node> backend;
    private HashSet<SelectorFunction<Node>> functions;
    private HashMap<String, NodeTransformer<?, Node>> transformers;
    private Configuration<Node> config;

    public LDPath(RDFBackend<Node> backend) {
        this(backend, new DefaultConfiguration());
    }

    public LDPath(RDFBackend<Node> backend, Configuration<Node> config) {
        this.backend = backend;
        this.functions = new HashSet();
        this.transformers = new HashMap();
        this.config = config;
    }

    public Collection<Node> pathQuery(Node context, String path, Map<String, String> namespaces) throws LDPathParseException {
        RdfPathParser<Node> parser = new RdfPathParser<Node>(this.backend, this.config, new StringReader(path));
        for (SelectorFunction<Node> function : this.functions) {
            parser.registerFunction(function);
        }
        for (String typeUri : this.transformers.keySet()) {
            parser.registerTransformer(typeUri, this.transformers.get(typeUri));
        }
        try {
            NodeSelector<Node> selector = parser.parseSelector(namespaces);
            return selector.select(this.backend, context, null, null);
        }
        catch (ParseException e) {
            throw new LDPathParseException("error while parsing path expression", e);
        }
    }

    public Collection<Node> pathQuery(Node context, String path, Map<String, String> namespaces, Map<Node, List<Node>> paths) throws LDPathParseException {
        RdfPathParser<Node> parser = new RdfPathParser<Node>(this.backend, this.config, new StringReader(path));
        for (SelectorFunction<Node> function : this.functions) {
            parser.registerFunction(function);
        }
        for (String typeUri : this.transformers.keySet()) {
            parser.registerTransformer(typeUri, this.transformers.get(typeUri));
        }
        try {
            NodeSelector<Node> selector = parser.parseSelector(namespaces);
            return selector.select(this.backend, context, (List)ImmutableList.of(), paths);
        }
        catch (ParseException e) {
            throw new LDPathParseException("error while parsing path expression", e);
        }
    }

    public <T> Collection<T> pathTransform(Node context, String path, Map<String, String> namespaces) throws LDPathParseException {
        RdfPathParser<Node> parser = new RdfPathParser<Node>(this.backend, this.config, new StringReader(path));
        for (SelectorFunction<Node> function : this.functions) {
            parser.registerFunction(function);
        }
        for (String typeUri : this.transformers.keySet()) {
            parser.registerTransformer(typeUri, this.transformers.get(typeUri));
        }
        try {
            FieldMapping mapping = parser.parseRule(namespaces);
            return mapping.getValues(this.backend, context);
        }
        catch (ParseException e) {
            throw new LDPathParseException("error while parsing path expression", e);
        }
    }

    public Map<String, Collection<?>> programQuery(Node context, Reader program) throws LDPathParseException {
        RdfPathParser<Node> parser = new RdfPathParser<Node>(this.backend, this.config, program);
        for (SelectorFunction<Node> function : this.functions) {
            parser.registerFunction(function);
        }
        for (String typeUri : this.transformers.keySet()) {
            parser.registerTransformer(typeUri, this.transformers.get(typeUri));
        }
        try {
            Program<Node> p = parser.parseProgram();
            HashMap result = new HashMap();
            for (FieldMapping<?, Node> mapping : p.getFields()) {
                result.put(mapping.getFieldName(), mapping.getValues(this.backend, context));
            }
            return result;
        }
        catch (ParseException e) {
            throw new LDPathParseException("error while parsing path expression", e);
        }
    }

    public Program<Node> parseProgram(Reader program) throws LDPathParseException {
        RdfPathParser<Node> parser = new RdfPathParser<Node>(this.backend, this.config, program);
        for (SelectorFunction<Node> function : this.functions) {
            parser.registerFunction(function);
        }
        for (String typeUri : this.transformers.keySet()) {
            parser.registerTransformer(typeUri, this.transformers.get(typeUri));
        }
        try {
            return parser.parseProgram();
        }
        catch (ParseException e) {
            throw new LDPathParseException("error while parsing path program", e);
        }
    }

    public void registerFunction(SelectorFunction<Node> function) {
        this.functions.add(function);
    }

    public Set<SelectorFunction<Node>> getFunctions() {
        return ImmutableSet.copyOf(this.functions);
    }

    public void registerTransformer(String typeUri, NodeTransformer<?, Node> transformer) {
        this.transformers.put(typeUri, transformer);
    }

    public Map<String, NodeTransformer<?, Node>> getTransformers() {
        return ImmutableMap.copyOf(this.transformers);
    }

    public Configuration<Node> getConfig() {
        return this.config;
    }
}

