/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.functions;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.functions.SelectorFunction;
import at.newmedialab.ldpath.model.transformers.StringTransformer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ConcatenateFunction<Node>
extends SelectorFunction<Node> {
    private final StringTransformer<Node> transformer = new StringTransformer();

    public Collection<Node> apply(RDFBackend<Node> rdfBackend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        Iterator<Node> it = at.newmedialab.ldpath.util.Collections.iterator(args);
        StringBuilder result = new StringBuilder();
        while (it.hasNext()) {
            result.append((String)this.transformer.transform((RDFBackend)rdfBackend, (Object)it.next()));
        }
        return Collections.singleton(rdfBackend.createLiteral(result.toString()));
    }

    public String getLocalName() {
        return "concat";
    }

    public String getSignature() {
        return "fn:concat(nodes : NodeList) : String";
    }

    public String getDescription() {
        return "A node function concatenating a list of nodes interpreted as strings.";
    }
}

