/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.selectors;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.functions.NodeFunction;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionSelector<Node>
implements NodeSelector<Node> {
    private List<NodeSelector<Node>> selectors;
    private NodeFunction<Collection<Node>, Node> function;

    public FunctionSelector(NodeFunction<Collection<Node>, Node> function, List<NodeSelector<Node>> selectors) {
        this.function = function;
        this.selectors = selectors;
    }

    public Collection<Node> select(RDFBackend<Node> nodeRDFBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        ArrayList<Collection> args = new ArrayList<Collection>();
        HashMap myResultPaths = null;
        if (resultPaths != null && path != null) {
            myResultPaths = new HashMap();
        }
        for (NodeSelector<Node> selector : this.selectors) {
            Collection param = selector.select(nodeRDFBackend, context, path, myResultPaths);
            args.add(param);
        }
        Collection result = (Collection)this.function.apply(nodeRDFBackend, context, args.toArray(new Collection[this.selectors.size()]));
        if (myResultPaths != null && path != null) {
            ArrayList functionPath = new ArrayList();
            for (List subpath : myResultPaths.values()) {
                for (Object n : subpath) {
                    if (functionPath.contains(n)) continue;
                    functionPath.add(n);
                }
            }
            for (Object n : result) {
                resultPaths.put(n, functionPath);
            }
        }
        return result;
    }

    public String getPathExpression(RDFBackend<Node> backend) {
        StringBuilder format = new StringBuilder();
        format.append(String.format("fn:%s(", this.function.getPathExpression(backend)));
        boolean first = true;
        for (NodeSelector<Node> ns : this.selectors) {
            if (!first) {
                format.append(", ");
            }
            format.append(ns.getPathExpression(backend));
            first = false;
        }
        return format.append(")").toString();
    }

    public String getName(RDFBackend<Node> nodeRDFBackend) {
        throw new UnsupportedOperationException("cannot use functions in unnamed field definitions because the name is ambiguous");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionSelector that = (FunctionSelector)o;
        if (this.function != null ? !this.function.equals(that.function) : that.function != null) {
            return false;
        }
        return !(this.selectors != null ? !((Object)this.selectors).equals(that.selectors) : that.selectors != null);
    }

    public int hashCode() {
        int result = this.selectors != null ? ((Object)this.selectors).hashCode() : 0;
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        return result;
    }
}

