/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.selectors;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PropertySelector<Node>
implements NodeSelector<Node> {
    private Node property;

    public PropertySelector(Node property) {
        this.property = property;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        if (rdfBackend.isURI(context) || rdfBackend.isBlank(context)) {
            if (path != null && resultPaths != null) {
                Collection results = rdfBackend.listObjects(context, this.property);
                for (Object n : results) {
                    resultPaths.put((Node)n, (List<Node>)new ImmutableList.Builder().addAll(path).add(context).add(n).build());
                }
                return results;
            }
            return rdfBackend.listObjects(context, this.property);
        }
        return Collections.emptyList();
    }

    public String getPathExpression(RDFBackend<Node> backend) {
        if (this.property != null) {
            return String.format("<%s>", backend.stringValue(this.property));
        }
        return "*";
    }

    public String getName(RDFBackend<Node> backend) {
        if (this.property != null) {
            return backend.stringValue(this.property);
        }
        throw new UnsupportedOperationException("cannot use wildcards in unnamed field definitions because the name is undefined");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySelector that = (PropertySelector)o;
        return !(this.property != null ? !this.property.equals(that.property) : that.property != null);
    }

    public int hashCode() {
        return this.property != null ? this.property.hashCode() : 0;
    }
}

