/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.selectors;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UnionSelector<Node>
implements NodeSelector<Node> {
    private NodeSelector<Node> left;
    private NodeSelector<Node> right;

    public UnionSelector(NodeSelector<Node> left, NodeSelector<Node> right) {
        this.left = left;
        this.right = right;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        HashSet result = new HashSet();
        result.addAll(this.left.select(rdfBackend, context, path, resultPaths));
        result.addAll(this.right.select(rdfBackend, context, path, resultPaths));
        return result;
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        return String.format("(%s | %s)", this.left.getPathExpression(rdfBackend), this.right.getPathExpression(rdfBackend));
    }

    public String getName(RDFBackend<Node> nodeRDFBackend) {
        throw new UnsupportedOperationException("cannot use unions in unnamed field definitions because the name is ambiguous");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionSelector that = (UnionSelector)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }
}

