/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.tests;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.tests.NodeTest;
import at.newmedialab.ldpath.model.tests.ComplexTest;

public class AndTest<Node>
extends ComplexTest<Node> {
    private NodeTest<Node> left;
    private NodeTest<Node> right;

    public AndTest(NodeTest<Node> left, NodeTest<Node> right) {
        this.left = left;
        this.right = right;
    }

    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node args) throws IllegalArgumentException {
        return this.left.accept(rdfBackend, context, args) && this.right.accept(rdfBackend, context, args);
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        return String.format("%s & %s", this.left.getPathExpression(rdfBackend), this.right.getPathExpression(rdfBackend));
    }

    public String getSignature() {
        return "(left  & right ) :: (Boolean, Boolean) -> Boolean";
    }

    public String getDescription() {
        return "Tests the conjunction of two tests";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AndTest andTest = (AndTest)((Object)o);
        if (this.left != null ? !this.left.equals(andTest.left) : andTest.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(andTest.right) : andTest.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }
}

