/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.tests;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.functions.TestFunction;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import at.newmedialab.ldpath.api.tests.NodeTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FunctionTest<Node>
extends NodeTest<Node> {
    private final TestFunction<Node> test;
    private final List<NodeSelector<Node>> argSelectors;

    public FunctionTest(TestFunction<Node> test, List<NodeSelector<Node>> argSelectors) {
        this.test = test;
        this.argSelectors = argSelectors;
    }

    public boolean accept(RDFBackend<Node> backend, Node context, Node target) throws IllegalArgumentException {
        ArrayList<Collection> fktArgs = new ArrayList<Collection>();
        for (NodeSelector<Node> sel : this.argSelectors) {
            fktArgs.add(sel.select(backend, target, null, null));
        }
        Boolean isAccepted = (Boolean)this.test.apply(backend, context, fktArgs.toArray(new Collection[this.argSelectors.size()]));
        return isAccepted;
    }

    public String getSignature() {
        return "(function, argument) :: (TestFunction, List<Nodes>) -> Boolean";
    }

    public String getDescription() {
        return "Delegate the test to a TestFunction";
    }

    public String getPathExpression(RDFBackend<Node> backend) {
        StringBuilder sb = new StringBuilder("fn:");
        sb.append(this.test.getLocalName());
        sb.append("(");
        boolean first = true;
        for (NodeSelector<Node> ns : this.argSelectors) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(ns.getPathExpression(backend));
            first = false;
        }
        return sb.append(")").toString();
    }
}

