/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.tests;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import at.newmedialab.ldpath.api.tests.NodeTest;
import java.util.Collection;

public class PathTest<Node>
extends NodeTest<Node> {
    private NodeSelector<Node> path;

    public PathTest(NodeSelector<Node> path) {
        this.path = path;
    }

    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node candidate) throws IllegalArgumentException {
        if (rdfBackend.isURI(candidate) || rdfBackend.isBlank(candidate)) {
            Collection testResult = this.path.select(rdfBackend, candidate, null, null);
            return testResult.size() > 0;
        }
        return false;
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        return this.path.getPathExpression(rdfBackend);
    }

    public String getSignature() {
        return "nodes :: NodeList -> Boolean";
    }

    public String getDescription() {
        return "Tests whether the node list is non-empty";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PathTest pathTest = (PathTest)((Object)o);
        return !(this.path != null ? !this.path.equals(pathTest.path) : pathTest.path != null);
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }
}

