/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.tests.functions;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.functions.TestFunction;
import at.newmedialab.ldpath.model.transformers.DoubleTransformer;
import java.util.Collection;

public abstract class BinaryNumericTest<Node>
extends TestFunction<Node> {
    protected final DoubleTransformer<Node> transformer = new DoubleTransformer();

    public final Boolean apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        if (args.length != 2) {
            throw new IllegalArgumentException(this.getLocalName() + " is a binary function and therefor requires exactly two arguments");
        }
        Collection<Node> leftArgs = args[0];
        Collection<Node> rightArgs = args[1];
        for (Node lN : leftArgs) {
            for (Node rN : rightArgs) {
                if (this.test(backend, lN, rN)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean test(RDFBackend<Node> backend, Node leftNode, Node rightNode) {
        try {
            return this.test((Double)this.transformer.transform((RDFBackend)backend, (Object)leftNode), (Double)this.transformer.transform((RDFBackend)backend, (Object)rightNode));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected abstract boolean test(Double var1, Double var2);

    public String getSignature() {
        return "fn:" + this.getLocalName() + "(NumericNode a, NumericNode b) :: Boolean";
    }
}

