/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.parser;

import at.newmedialab.ldpath.api.functions.SelectorFunction;
import at.newmedialab.ldpath.api.functions.TestFunction;
import at.newmedialab.ldpath.api.transformers.NodeTransformer;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration<Node> {
    private static Logger log = LoggerFactory.getLogger(Configuration.class);
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Map<String, NodeTransformer<?, Node>> transformers = new HashMap();
    protected Map<String, SelectorFunction<Node>> functions = new HashMap<String, SelectorFunction<Node>>();
    protected Map<String, TestFunction<Node>> testFunctions = new HashMap<String, TestFunction<Node>>();

    public Map<String, String> getNamespaces() {
        return ImmutableMap.copyOf(this.namespaces);
    }

    public Map<String, NodeTransformer<?, Node>> getTransformers() {
        return ImmutableMap.copyOf(this.transformers);
    }

    public Map<String, SelectorFunction<Node>> getFunctions() {
        return ImmutableMap.copyOf(this.functions);
    }

    public Map<String, TestFunction<Node>> getTestFunctions() {
        return ImmutableMap.copyOf(this.testFunctions);
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public void removeNamespace(String prefix) {
        this.namespaces.remove(prefix);
    }

    public void addFunction(String uri, SelectorFunction<Node> function) {
        if (!uri.startsWith("http://www.newmedialab.at/lmf/functions/1.0/")) {
            log.warn("Attempt to add a function from an external namespace: <{}>", (Object)uri);
            throw new IllegalArgumentException("namespaces other than http://www.newmedialab.at/lmf/functions/1.0/ are currently not supported");
        }
        this.functions.put(uri, function);
    }

    public void removeFunction(String uri) {
        this.functions.remove(uri);
    }

    public void addTestFunction(String uri, TestFunction<Node> test) {
        if (!uri.startsWith("http://www.newmedialab.at/lmf/functions/1.0/")) {
            log.warn("Attempt to add a test function from an external namespace: <{}>", (Object)uri);
            throw new IllegalArgumentException("namespaces other than http://www.newmedialab.at/lmf/functions/1.0/ are currently not supported");
        }
        this.testFunctions.put(uri, test);
    }

    public void removeTestFunction(String uri) {
        this.testFunctions.remove(uri);
    }

    public void addTransformer(String uri, NodeTransformer<?, Node> transformer) {
        this.transformers.put(uri, transformer);
    }

    public void removeTransformer(String uri) {
        this.transformers.remove(uri);
    }
}

