/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.parser;

import at.newmedialab.ldpath.api.functions.SelectorFunction;
import at.newmedialab.ldpath.api.functions.TestFunction;
import at.newmedialab.ldpath.model.functions.ConcatenateFunction;
import at.newmedialab.ldpath.model.functions.FirstFunction;
import at.newmedialab.ldpath.model.functions.LastFunction;
import at.newmedialab.ldpath.model.functions.SortFunction;
import at.newmedialab.ldpath.model.transformers.BigDecimalTransformer;
import at.newmedialab.ldpath.model.transformers.BigIntegerTransformer;
import at.newmedialab.ldpath.model.transformers.BooleanTransformer;
import at.newmedialab.ldpath.model.transformers.ByteTransformer;
import at.newmedialab.ldpath.model.transformers.DateTimeTransformer;
import at.newmedialab.ldpath.model.transformers.DateTransformer;
import at.newmedialab.ldpath.model.transformers.DoubleTransformer;
import at.newmedialab.ldpath.model.transformers.DurationTransformer;
import at.newmedialab.ldpath.model.transformers.FloatTransformer;
import at.newmedialab.ldpath.model.transformers.IntTransformer;
import at.newmedialab.ldpath.model.transformers.LongTransformer;
import at.newmedialab.ldpath.model.transformers.ShortTransformer;
import at.newmedialab.ldpath.model.transformers.StringTransformer;
import at.newmedialab.ldpath.model.transformers.TimeTransformer;
import at.newmedialab.ldpath.parser.Configuration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfiguration<Node>
extends Configuration<Node> {
    private static Logger log = LoggerFactory.getLogger(DefaultConfiguration.class);
    private static ServiceLoader<SelectorFunction> functionLoader = ServiceLoader.load(SelectorFunction.class);
    private static ServiceLoader<TestFunction> testLoader = ServiceLoader.load(TestFunction.class);
    public static final Map<String, String> DEFAULT_NAMESPACES;
    public static final Set<Class<?>> DEFAULT_FUNCTIONS;

    public DefaultConfiguration() {
        this.addDefaultNamespaces();
        this.addDefaultTransformers();
        this.addDefaultFunctions();
        this.addDefaultTestFunctions();
    }

    private void addDefaultNamespaces() {
        this.namespaces.putAll(DEFAULT_NAMESPACES);
    }

    private void addDefaultTransformers() {
        this.addTransformer("http://www.w3.org/2001/XMLSchema#decimal", new BigDecimalTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#integer", new BigIntegerTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#long", new LongTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#int", new IntTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#short", new ShortTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#byte", new ByteTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#double", new DoubleTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#float", new FloatTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#dateTime", new DateTimeTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#date", new DateTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#time", new TimeTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#boolean", new BooleanTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#anyURI", new StringTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#string", new StringTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#duration", new DurationTransformer());
    }

    private void addDefaultFunctions() {
        for (SelectorFunction f : functionLoader) {
            log.info("registering LDPath function: {}", (Object)f.getSignature());
            this.addFunction(f);
        }
    }

    private void addFunction(SelectorFunction<Node> function) {
        this.addFunction("http://www.newmedialab.at/lmf/functions/1.0/" + function.getPathExpression(null), function);
    }

    private void addDefaultTestFunctions() {
        for (TestFunction t : testLoader) {
            log.info("registering LDPath test function: {}", (Object)t.getSignature());
            this.addTestFunction(t);
        }
    }

    private void addTestFunction(TestFunction<Node> test) {
        this.addTestFunction("http://www.newmedialab.at/lmf/functions/1.0/" + test.getLocalName(), test);
    }

    static {
        HashMap<String, String> defNS = new HashMap<String, String>();
        defNS.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        defNS.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        defNS.put("owl", "http://www.w3.org/2002/07/owl#");
        defNS.put("skos", "http://www.w3.org/2004/02/skos/core#");
        defNS.put("foaf", "http://xmlns.com/foaf/0.1/");
        defNS.put("dc", "http://purl.org/dc/elements/1.1/");
        defNS.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        defNS.put("lmf", "http://www.newmedialab.at/lmf/types/1.0/");
        defNS.put("fn", "http://www.newmedialab.at/lmf/functions/1.0/");
        DEFAULT_NAMESPACES = Collections.unmodifiableMap(defNS);
        DEFAULT_FUNCTIONS = new HashSet();
        DEFAULT_FUNCTIONS.add(ConcatenateFunction.class);
        DEFAULT_FUNCTIONS.add(FirstFunction.class);
        DEFAULT_FUNCTIONS.add(LastFunction.class);
        DEFAULT_FUNCTIONS.add(SortFunction.class);
    }
}

