/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Collections {
    public static <T> List<T> concat(Collection<T> ... lists) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    public static <T> Iterator<T> iterator(Collection<T> ... lists) {
        return Collections.iterator(0, lists);
    }

    public static <T> Iterator<T> iterator(final int offset, final Collection<T> ... lists) {
        if (offset < 0) {
            throw new IllegalArgumentException("The parsed Offest MUST NOT be < 0!");
        }
        if (lists == null) {
            return null;
        }
        if (lists.length <= offset) {
            return java.util.Collections.emptyList().iterator();
        }
        return new Iterator<T>(){
            private int listsIndex;
            private Iterator<T> it;
            {
                this.listsIndex = offset - 1;
            }

            @Override
            public boolean hasNext() {
                while (this.it == null || !this.it.hasNext()) {
                    ++this.listsIndex;
                    if (this.listsIndex < lists.length) {
                        Collection list = lists[this.listsIndex];
                        if (list == null) continue;
                        this.it = lists[this.listsIndex].iterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (this.it == null) {
                    this.hasNext();
                }
                return this.it.next();
            }

            @Override
            public void remove() {
                if (this.it != null) {
                    this.it.remove();
                }
            }
        };
    }
}

