/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class FormatUtils {
    public static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final SimpleDateFormat ISO8601FORMAT_TIME = new SimpleDateFormat("HH:mm:ss.SSSZ");
    public static final SimpleDateFormat ISO8601FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat[] iso8601InputFormats = new DateFormat[]{FormatUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "UTF"), FormatUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", null), FormatUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", null), FormatUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", "UTF"), FormatUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", null), FormatUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss", null), FormatUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS'Z'", "UTF"), FormatUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSSZ", null), FormatUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS", null), FormatUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'", "UTF"), FormatUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ssZ", null), FormatUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss", null), FormatUtils.createDateFormat("EEE MMM dd HH:mm:ss z yyyy", null), FormatUtils.createDateFormat("EEE MMM d HH:mm:ss z yyyy", null), FormatUtils.createDateFormat("dd.MM.yyyy' 'HH:mm:ss", null), FormatUtils.createDateFormat("dd.MM.yyyy' 'HH:mm", null)};

    private static DateFormat createDateFormat(String format, String timezone) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, new DateFormatSymbols(Locale.US));
        if (timezone != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return sdf;
    }

    public static synchronized Date parseDate(String date) {
        if (date == null) {
            return null;
        }
        int n = date.length();
        if (date.charAt(n - 3) == ':' && (date.charAt(n - 6) == '+' || date.charAt(n - 6) == '-')) {
            date = date.substring(0, n - 3) + date.substring(n - 2);
        }
        for (DateFormat format : iso8601InputFormats) {
            try {
                return format.parse(date);
            }
            catch (ParseException ignore) {
            }
        }
        return null;
    }
}

