/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.fields;

import at.newmedialab.ldpath.api.LDPathConstruct;
import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import at.newmedialab.ldpath.api.transformers.NodeTransformer;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FieldMapping<T, Node>
implements LDPathConstruct<Node> {
    private String fieldName;
    private String fieldType;
    private NodeSelector<Node> selector;
    private NodeTransformer<T, Node> transformer;
    private Map<String, String> fieldConfig;

    public FieldMapping() {
    }

    public FieldMapping(String fieldName, String fieldType, NodeSelector<Node> selector, NodeTransformer<T, Node> transformer, Map<String, String> fieldConfig) {
        this();
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.selector = selector;
        this.transformer = transformer;
        this.fieldConfig = fieldConfig;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public NodeSelector<Node> getSelector() {
        return this.selector;
    }

    public void setSelector(NodeSelector<Node> selector) {
        this.selector = selector;
    }

    public NodeTransformer<T, Node> getTransformer() {
        return this.transformer;
    }

    public void setTransformer(NodeTransformer<T, Node> transformer) {
        this.transformer = transformer;
    }

    public Map<String, String> getFieldConfig() {
        return this.fieldConfig;
    }

    public void setFieldConfig(Map<String, String> fieldConfig) {
        this.fieldConfig = fieldConfig;
    }

    public Collection<T> getValues(final RDFBackend<Node> backend, Node context, Map<Node, List<Node>> paths) {
        Function function = new Function<Node, T>(){

            public T apply(Node input) {
                return FieldMapping.this.transformer.transform(backend, input);
            }
        };
        return Collections2.transform((Collection)this.selector.select(backend, context, (List)ImmutableList.of(context), paths), (Function)function);
    }

    public Collection<T> getValues(final RDFBackend<Node> backend, Node context) {
        Function function = new Function<Node, T>(){

            public T apply(Node input) {
                return FieldMapping.this.transformer.transform(backend, input);
            }
        };
        return Collections2.transform((Collection)this.selector.select(backend, context, null, null), (Function)function);
    }

    public String getPathExpression(RDFBackend<Node> backend) {
        StringBuilder fc = new StringBuilder();
        if (this.fieldConfig != null) {
            fc.append("(");
            boolean first = true;
            for (Map.Entry<String, String> e : this.fieldConfig.entrySet()) {
                if (!first) {
                    fc.append(", ");
                }
                fc.append(e.getKey()).append("=\"").append(e.getValue()).append("\"");
                first = false;
            }
            fc.append(")");
        }
        return String.format("%s = %s :: <%s>%s ;", this.fieldName, this.selector.getPathExpression(backend), this.fieldType, fc.toString());
    }
}

