/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.functions;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.functions.SelectorFunction;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;

public class CountFunction<Node>
extends SelectorFunction<Node> {
    private final URI dataType = URI.create("http://www.w3.org/2001/XMLSchema#integer");

    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Collection<Node> coll : args) {
            Object intLit = backend.createLiteral(String.valueOf(coll.size()), null, this.dataType);
            result.add(intLit);
        }
        return result;
    }

    public String getSignature() {
        return "fn:count(nodes : URIResourceList, ...) : IntegerLiteralList";
    }

    public String getDescription() {
        return "Counts the number of resources in the arguments";
    }

    public String getLocalName() {
        return "count";
    }
}

