/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.selectors;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PathSelector<Node>
implements NodeSelector<Node> {
    private NodeSelector<Node> left;
    private NodeSelector<Node> right;

    public PathSelector(NodeSelector<Node> left, NodeSelector<Node> right) {
        this.left = left;
        this.right = right;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        HashMap myResultPaths = null;
        if (resultPaths != null && path != null) {
            myResultPaths = new HashMap();
        }
        Collection nodesLeft = this.left.select(rdfBackend, context, path, myResultPaths);
        HashSet result = new HashSet();
        for (Object n : nodesLeft) {
            if (myResultPaths != null && myResultPaths.get(n) != null) {
                result.addAll(this.right.select(rdfBackend, n, (List)myResultPaths.get(n), resultPaths));
                continue;
            }
            result.addAll(this.right.select(rdfBackend, n, null, null));
        }
        return result;
    }

    public String getPathExpression(RDFBackend<Node> backend) {
        return String.format("%s / %s", this.left.getPathExpression(backend), this.right.getPathExpression(backend));
    }

    public String getName(RDFBackend<Node> nodeRDFBackend) {
        return this.left.getName(nodeRDFBackend);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathSelector that = (PathSelector)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }
}

