/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.selectors;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecursivePathSelector<Node>
implements NodeSelector<Node> {
    private final NodeSelector<Node> delegate;
    private final int minRecursions;
    private final int maxRecursions;

    public RecursivePathSelector(NodeSelector<Node> delegate, int min, int max) {
        this.delegate = delegate;
        this.minRecursions = min;
        this.maxRecursions = max;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        HashSet<Node> result = new HashSet<Node>();
        if (this.minRecursions <= 0) {
            result.add(context);
        }
        this.subSelect(context, 0, rdfBackend, result, path, resultPaths);
        return result;
    }

    private void subSelect(Node currentContext, int depth, RDFBackend<Node> rdfBackend, Set<Node> resultSet, List<Node> path, Map<Node, List<Node>> resultPaths) {
        Collection nextNodes = this.delegate.select(rdfBackend, currentContext, path, resultPaths);
        ++depth;
        for (Object n : nextNodes) {
            if (resultSet.contains(n)) continue;
            if (depth >= this.minRecursions) {
                resultSet.add(n);
            }
            if (depth >= this.maxRecursions) continue;
            if (path != null && resultPaths != null) {
                this.subSelect((Node)n, depth, rdfBackend, resultSet, (List<Node>)new ImmutableList.Builder().addAll(path).add(currentContext).build(), resultPaths);
                continue;
            }
            this.subSelect(n, depth, rdfBackend, resultSet, null, resultPaths);
        }
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        if (this.maxRecursions != Integer.MAX_VALUE) {
            if (this.minRecursions <= 0) {
                return String.format("(%s){,%d}", this.delegate.getPathExpression(rdfBackend), this.maxRecursions);
            }
            return String.format("(%s){%d,%d}", this.delegate.getPathExpression(rdfBackend), this.minRecursions, this.maxRecursions);
        }
        if (this.minRecursions <= 0) {
            return String.format("(%s)*", this.delegate.getPathExpression(rdfBackend));
        }
        if (this.minRecursions == 1) {
            return String.format("(%s)+", this.delegate.getPathExpression(rdfBackend));
        }
        return String.format("(%s){%d,}", this.delegate.getPathExpression(rdfBackend), this.minRecursions);
    }

    public String getName(RDFBackend<Node> nodeRDFBackend) {
        return this.delegate.getName(nodeRDFBackend);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorStared(NodeSelector<N> delegate) {
        return new RecursivePathSelector<N>(delegate, 0, Integer.MAX_VALUE);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorPlused(NodeSelector<N> delegate) {
        return new RecursivePathSelector<N>(delegate, 1, Integer.MAX_VALUE);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorMinBound(NodeSelector<N> delegate, int minBound) {
        return new RecursivePathSelector<N>(delegate, minBound, Integer.MAX_VALUE);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorMaxBound(NodeSelector<N> delegate, int maxBound) {
        return new RecursivePathSelector<N>(delegate, 0, maxBound);
    }

    public static <N> RecursivePathSelector<N> getPathSelectorMinMaxBound(NodeSelector<N> delegate, int minBound, int maxBound) {
        return new RecursivePathSelector<N>(delegate, minBound, maxBound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursivePathSelector that = (RecursivePathSelector)o;
        return !(this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null);
    }

    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : 0;
    }
}

