/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.selectors;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StringConstantSelector<Node>
implements NodeSelector<Node> {
    private String constant;

    public StringConstantSelector(String constant) {
        this.constant = constant;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        return Collections.singleton(rdfBackend.createLiteral(this.constant));
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        return String.format("\"%s\"", this.constant);
    }

    public String getName(RDFBackend<Node> nodeRDFBackend) {
        return this.constant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringConstantSelector that = (StringConstantSelector)o;
        return !(this.constant != null ? !this.constant.equals(that.constant) : that.constant != null);
    }

    public int hashCode() {
        return this.constant != null ? this.constant.hashCode() : 0;
    }
}

