/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.tests;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.tests.NodeTest;
import java.util.Locale;

public class LiteralLanguageTest<Node>
extends NodeTest<Node> {
    private String lang;

    public LiteralLanguageTest(String lang) {
        this.lang = lang;
    }

    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node node) throws IllegalArgumentException {
        if (rdfBackend.isLiteral(node)) {
            if (this.lang != null && !this.lang.toLowerCase().equals("none")) {
                return new Locale(this.lang).equals(rdfBackend.getLiteralLanguage(node));
            }
            return rdfBackend.getLiteralLanguage(node) == null;
        }
        return false;
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        return "@" + this.lang;
    }

    public String getSignature() {
        return "nodes [@lang] :: (NodeList, Language) -> Boolean";
    }

    public String getDescription() {
        return "Tests the language of the literal nodes passed as argument";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LiteralLanguageTest that = (LiteralLanguageTest)((Object)o);
        return !(this.lang != null ? !this.lang.equals(that.lang) : that.lang != null);
    }

    public int hashCode() {
        return this.lang != null ? this.lang.hashCode() : 0;
    }
}

