/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.model.tests;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.tests.NodeTest;

public class LiteralTypeTest<Node>
extends NodeTest<Node> {
    private String typeUri;

    public LiteralTypeTest(String typeUri) {
        this.typeUri = typeUri;
    }

    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node node) throws IllegalArgumentException {
        if (rdfBackend.isLiteral(node)) {
            if (this.typeUri != null) {
                return this.typeUri.equals(rdfBackend.getLiteralType(node).toString());
            }
            return null == rdfBackend.getLiteralType(node).toString();
        }
        return false;
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        return "^^" + this.typeUri;
    }

    public String getSignature() {
        return "nodes [^^typeUri] :: (NodeList, URI) -> Boolean";
    }

    public String getDescription() {
        return "Tests the types of the nodes passed as argument";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LiteralTypeTest that = (LiteralTypeTest)((Object)o);
        return !(this.typeUri != null ? !this.typeUri.equals(that.typeUri) : that.typeUri != null);
    }

    public int hashCode() {
        return this.typeUri != null ? this.typeUri.hashCode() : 0;
    }
}

