/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.realm;

import br.eti.arthurgregorio.shiroee.auth.AuthenticationMechanism;
import br.eti.arthurgregorio.shiroee.auth.EmptyAuthenticationMechanism;
import br.eti.arthurgregorio.shiroee.config.jdbc.UserDetails;
import br.eti.arthurgregorio.shiroee.config.ldap.LdapUserProvider;
import br.eti.arthurgregorio.shiroee.config.messages.Messages;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.DefaultLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;

public class LdapSecurityRealm
extends DefaultLdapRealm {
    private final LdapUserProvider ldapUserProvider;
    private final AuthenticationMechanism<? extends UserDetails> mechanism;

    public LdapSecurityRealm(LdapUserProvider ldapUserProvider, AuthenticationMechanism mechanism) {
        this.ldapUserProvider = ldapUserProvider;
        this.mechanism = mechanism == null ? new EmptyAuthenticationMechanism() : mechanism;
    }

    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory factory) throws NamingException {
        String username = String.valueOf(token.getPrincipal());
        UserDetails userDetails = this.mechanism.getAccount(username);
        if (userDetails.isLdapBindAccount() && !userDetails.isBlocked()) {
            return super.queryForAuthenticationInfo(token, factory);
        }
        throw new IncorrectCredentialsException(Messages.AUTHENTICATION_ERROR.format(username));
    }

    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principalCollection, LdapContextFactory factory) throws NamingException {
        String username = (String)this.getAvailablePrincipal(principalCollection);
        Set<String> permissions = this.mechanism.getPermissions(username);
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        authorizationInfo.setStringPermissions(permissions);
        return authorizationInfo;
    }

    protected String getUserDn(String principal) {
        return this.ldapUserProvider.search(principal).orElseThrow(() -> new UnknownAccountException(Messages.AUTHENTICATION_ERROR.format(principal))).getDistinguishedName();
    }
}

