/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.auth;

import br.eti.arthurgregorio.shiroee.auth.AuthenticationMechanism;
import br.eti.arthurgregorio.shiroee.config.jdbc.UserDetails;
import br.eti.arthurgregorio.shiroee.config.jdbc.UserDetailsProvider;
import com.google.common.base.Preconditions;
import java.util.Set;

public class DatabaseAuthenticationMechanism
implements AuthenticationMechanism<UserDetails> {
    private final UserDetailsProvider userDetailsProvider;

    public DatabaseAuthenticationMechanism(UserDetailsProvider userDetailsProvider) {
        this.userDetailsProvider = (UserDetailsProvider)Preconditions.checkNotNull((Object)userDetailsProvider);
    }

    @Override
    public UserDetails getAccount(String username) {
        return this.userDetailsProvider.findByUsername(username);
    }

    @Override
    public Set<String> getPermissions(String username) {
        UserDetails userDetails = this.userDetailsProvider.findByUsername(username);
        return userDetails.getPermissions();
    }
}

