/*
 * Decompiled with CFR 0.152.
 */
package br.eti.arthurgregorio.shiroee.config.http;

import br.eti.arthurgregorio.shiroee.config.ConfigurationFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;

public abstract class HttpSecurityBuilder {
    private final String authcOperator;
    private final Map<String, String> rules;
    protected final PropertiesConfiguration configuration = ConfigurationFactory.get();

    public HttpSecurityBuilder() {
        this.rules = new HashMap<String, String>();
        this.authcOperator = this.configuration.getString("operator.authenticated", "authc");
    }

    public abstract String getBuilderOperator();

    public HttpSecurityBuilder add(String path, String rule) {
        return this.add(path, rule, false);
    }

    public HttpSecurityBuilder add(String path, String rule, boolean authenticated) {
        if (authenticated) {
            this.rules.put(path, this.authcOperator + "," + this.format(rule));
        } else {
            this.rules.put(path, this.format(rule));
        }
        return this;
    }

    public Map<String, String> build() {
        return Collections.unmodifiableMap(this.rules);
    }

    private String format(String rule) {
        return String.format(this.getBuilderOperator(), rule);
    }
}

