/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;

/*
 * Exception performing whole class analysis ignored.
 */
class GridmixKey
extends GridmixRecord {
    static final byte REDUCE_SPEC = 0;
    static final byte DATA = 1;
    static final int META_BYTES = 1;
    private byte type;
    private int partition;
    private Spec spec = new Spec();

    GridmixKey() {
        this(1, 1, 0L);
    }

    GridmixKey(byte type, int size, long seed) {
        super(size, seed);
        this.type = type;
        this.setSize(size);
    }

    public int getSize() {
        switch (this.type) {
            case 0: {
                return super.getSize() + this.spec.getSize() + 1;
            }
            case 1: {
                return super.getSize() + 1;
            }
        }
        throw new IllegalStateException("Invalid type: " + this.type);
    }

    public void setSize(int size) {
        switch (this.type) {
            case 0: {
                super.setSize(size - (1 + this.spec.getSize()));
                break;
            }
            case 1: {
                super.setSize(size - 1);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public int getPartition() {
        return this.partition;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public long getReduceInputRecords() {
        assert (0 == this.getType());
        return this.spec.rec_in;
    }

    public void setReduceInputRecords(long rec_in) {
        assert (0 == this.getType());
        int origSize = this.getSize();
        this.spec.rec_in = rec_in;
        this.setSize(origSize);
    }

    public long getReduceOutputRecords() {
        assert (0 == this.getType());
        return this.spec.rec_out;
    }

    public void setReduceOutputRecords(long rec_out) {
        assert (0 == this.getType());
        int origSize = this.getSize();
        this.spec.rec_out = rec_out;
        this.setSize(origSize);
    }

    public long getReduceOutputBytes() {
        assert (0 == this.getType());
        return this.spec.bytes_out;
    }

    public void setReduceOutputBytes(long b_out) {
        assert (0 == this.getType());
        int origSize = this.getSize();
        this.spec.bytes_out = b_out;
        this.setSize(origSize);
    }

    public ResourceUsageMetrics getReduceResourceUsageMetrics() {
        assert (0 == this.getType());
        return Spec.access$000((Spec)this.spec);
    }

    public void setReduceResourceUsageMetrics(ResourceUsageMetrics metrics) {
        assert (0 == this.getType());
        this.spec.setResourceUsageSpecification(metrics);
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) throws IOException {
        int origSize = this.getSize();
        switch (type) {
            case 0: 
            case 1: {
                this.type = type;
                break;
            }
            default: {
                throw new IOException("Invalid type: " + type);
            }
        }
        this.setSize(origSize);
    }

    public void setSpec(Spec spec) {
        assert (0 == this.getType());
        int origSize = this.getSize();
        this.spec.set(spec);
        this.setSize(origSize);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.setType(in.readByte());
        if (0 == this.getType()) {
            this.spec.readFields(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        byte t = this.getType();
        out.writeByte(t);
        if (0 == t) {
            this.spec.write(out);
        }
    }

    int fixedBytes() {
        return super.fixedBytes() + (0 == this.getType() ? this.spec.getSize() : 0) + 1;
    }

    public int compareTo(GridmixRecord other) {
        byte t2;
        GridmixKey o = (GridmixKey)other;
        byte t1 = this.getType();
        if (t1 != (t2 = o.getType())) {
            return t1 - t2;
        }
        return super.compareTo(other);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            GridmixKey o = (GridmixKey)other;
            return this.getType() == o.getType() && super.equals((Object)o);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.getType();
    }
}

