/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GridmixTestUtils {
    private static final Log LOG = LogFactory.getLog(GridmixTestUtils.class);
    static final Path DEST = new Path("/gridmix");
    static FileSystem dfs = null;
    static MiniDFSCluster dfsCluster = null;
    static MiniMRClientCluster mrvl = null;
    protected static final String GRIDMIX_USE_QUEUE_IN_TRACE = "gridmix.job-submission.use-queue-in-trace";
    protected static final String GRIDMIX_DEFAULT_QUEUE = "gridmix.job-submission.default-queue";

    public static void initCluster(Class<?> caller) throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapred.queue.names", "default");
        conf.set("yarn.scheduler.capacity.root.queues", "default");
        conf.set("yarn.scheduler.capacity.root.default.capacity", "100.0");
        conf.setBoolean("gridmix.job-submission.use-queue-in-trace", false);
        conf.set("gridmix.job-submission.default-queue", "default");
        dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        dfs = dfsCluster.getFileSystem();
        conf.set("mapreduce.jobtracker.retirejobs", "false");
        mrvl = MiniMRClientClusterFactory.create(caller, (int)2, (Configuration)conf);
        conf = mrvl.getConfig();
        String[] files = conf.getStrings("mapreduce.job.cache.files");
        if (files != null) {
            String[] timestamps = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                timestamps[i] = Long.toString(System.currentTimeMillis());
            }
            conf.setStrings("mapreduce.job.cache.files.timestamps", timestamps);
        }
    }

    public static void shutdownCluster() throws IOException {
        if (mrvl != null) {
            mrvl.stop();
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    public static void createHomeAndStagingDirectory(String user, Configuration conf) {
        try {
            DistributedFileSystem fs = dfsCluster.getFileSystem();
            String path = "/user/" + user;
            Path homeDirectory = new Path(path);
            if (!fs.exists(homeDirectory)) {
                LOG.info((Object)("Creating Home directory : " + homeDirectory));
                fs.mkdirs(homeDirectory);
                GridmixTestUtils.changePermission((String)user, (Path)homeDirectory, (FileSystem)fs);
            }
            GridmixTestUtils.changePermission((String)user, (Path)homeDirectory, (FileSystem)fs);
            Path stagingArea = new Path(conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
            LOG.info((Object)("Creating Staging root directory : " + stagingArea));
            fs.mkdirs(stagingArea);
            fs.setPermission(stagingArea, new FsPermission(511));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static void changePermission(String user, Path homeDirectory, FileSystem fs) throws IOException {
        fs.setOwner(homeDirectory, user, "");
    }
}

