/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.StatListener;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Statistics
implements Gridmix.Component<JobStats> {
    public static final Log LOG = LogFactory.getLog(Statistics.class);
    private final StatCollector statistics = new StatCollector(this);
    private JobClient cluster;
    private final List<StatListener<ClusterStats>> clusterStatlisteners = new CopyOnWriteArrayList();
    private final List<StatListener<JobStats>> jobStatListeners = new CopyOnWriteArrayList();
    private static final Map<Integer, JobStats> submittedJobsMap = new ConcurrentHashMap();
    private static volatile int numMapsSubmitted = 0;
    private static volatile int numReducesSubmitted = 0;
    private int completedJobsInCurrentInterval = 0;
    private final int jtPollingInterval;
    private volatile boolean shutdown = false;
    private final int maxJobCompletedInInterval;
    private static final String MAX_JOBS_COMPLETED_IN_POLL_INTERVAL_KEY = "gridmix.max-jobs-completed-in-poll-interval";
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition jobCompleted = this.lock.newCondition();
    private final CountDownLatch startFlag;

    public Statistics(Configuration conf, int pollingInterval, CountDownLatch startFlag) throws IOException, InterruptedException {
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        this.cluster = (JobClient)ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        this.jtPollingInterval = pollingInterval;
        this.maxJobCompletedInInterval = conf.getInt("gridmix.max-jobs-completed-in-poll-interval", 1);
        this.startFlag = startFlag;
    }

    public static JobStats generateJobStats(Job job, JobStory jobdesc) {
        int seq = GridmixJob.getJobSeqId((JobContext)job);
        if (seq >= 0 && jobdesc == null) {
            throw new IllegalArgumentException("JobStory not available for job " + job.getJobID());
        }
        int maps = -1;
        int reds = -1;
        if (jobdesc != null) {
            maps = jobdesc.getNumberMaps();
            reds = jobdesc.getNumberReduces();
        }
        return new JobStats(maps, reds, job);
    }

    private static void addToNumMapsSubmitted(int numMaps) {
        numMapsSubmitted += numMaps;
    }

    private static void addToNumReducesSubmitted(int numReduces) {
        numReducesSubmitted += numReduces;
    }

    private static void subtractFromNumMapsSubmitted(int numMaps) {
        numMapsSubmitted -= numMaps;
    }

    private static void subtractFromNumReducesSubmitted(int numReduces) {
        numReducesSubmitted -= numReduces;
    }

    public void addJobStats(JobStats stats) {
        int seq = GridmixJob.getJobSeqId((JobContext)stats.getJob());
        if (seq < 0) {
            LOG.info((Object)("Not tracking job " + stats.getJob().getJobName() + " as seq id is less than zero: " + seq));
            return;
        }
        submittedJobsMap.put(seq, stats);
        Statistics.addToNumMapsSubmitted((int)stats.getNoOfMaps());
        Statistics.addToNumReducesSubmitted((int)stats.getNoOfReds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JobStats job) {
        if (!this.statistics.isAlive()) {
            return;
        }
        JobStats stat = (JobStats)submittedJobsMap.remove(GridmixJob.getJobSeqId((JobContext)job.getJob()));
        if (stat == null) {
            LOG.error((Object)("[Statistics] Missing entry for job " + job.getJob().getJobID()));
            return;
        }
        Statistics.subtractFromNumMapsSubmitted((int)stat.getNoOfMaps());
        Statistics.subtractFromNumReducesSubmitted((int)stat.getNoOfReds());
        ++this.completedJobsInCurrentInterval;
        if (this.completedJobsInCurrentInterval >= this.maxJobCompletedInInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" Reached maximum limit of jobs in a polling interval " + this.completedJobsInCurrentInterval));
            }
            this.completedJobsInCurrentInterval = 0;
            this.lock.lock();
            try {
                for (StatListener l : this.jobStatListeners) {
                    l.update((Object)stat);
                }
                this.jobCompleted.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void addClusterStatsObservers(StatListener<ClusterStats> listener) {
        this.clusterStatlisteners.add(listener);
    }

    public void addJobStatsListeners(StatListener<JobStats> listener) {
        this.jobStatListeners.add(listener);
    }

    public void start() {
        this.statistics.start();
    }

    public void join(long millis) throws InterruptedException {
        this.statistics.join(millis);
    }

    public void shutdown() {
        this.shutdown = true;
        submittedJobsMap.clear();
        this.clusterStatlisteners.clear();
        this.jobStatListeners.clear();
        this.statistics.interrupt();
    }

    public void abort() {
        this.shutdown = true;
        submittedJobsMap.clear();
        this.clusterStatlisteners.clear();
        this.jobStatListeners.clear();
        this.statistics.interrupt();
    }

    static /* synthetic */ CountDownLatch access$000(Statistics x0) {
        return x0.startFlag;
    }

    static /* synthetic */ boolean access$100(Statistics x0) {
        return x0.shutdown;
    }

    static /* synthetic */ ReentrantLock access$200(Statistics x0) {
        return x0.lock;
    }

    static /* synthetic */ int access$300(Statistics x0) {
        return x0.jtPollingInterval;
    }

    static /* synthetic */ Condition access$400(Statistics x0) {
        return x0.jobCompleted;
    }

    static /* synthetic */ List access$500(Statistics x0) {
        return x0.clusterStatlisteners;
    }

    static /* synthetic */ JobClient access$600(Statistics x0) {
        return x0.cluster;
    }

    static /* synthetic */ Map access$700() {
        return submittedJobsMap;
    }

    static /* synthetic */ int access$800() {
        return numMapsSubmitted;
    }

    static /* synthetic */ int access$900() {
        return numReducesSubmitted;
    }
}

