/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.FileQueue;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.mapred.gridmix.TestCompressionEmulationUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCompressionEmulationUtils {
    @Test
    public void testRandomCompressedTextDataGenerator() throws Exception {
        int wordSize = 10;
        int listSize = 20;
        long dataSize = 0xA00000L;
        Configuration conf = new Configuration();
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        CompressionEmulationUtil.setInputCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setInt("gridmix.datagenerator.randomtext.listsize", listSize);
        conf.setInt("gridmix.datagenerator.randomtext.wordsize", wordSize);
        conf.setLong("gridmix.gen.bytes", dataSize);
        conf.set("mapreduce.job.hdfs-servers", "");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path tempDir = new Path(rootTempDir, "TestRandomCompressedTextDataGenr");
        lfs.delete(tempDir, true);
        TestCompressionEmulationUtils.runDataGenJob((Configuration)conf, (Path)tempDir);
        FileStatus[] files = lfs.listStatus(tempDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter());
        long size = 0L;
        long maxLineSize = 0L;
        for (FileStatus status : files) {
            InputStream in = CompressionEmulationUtil.getPossiblyDecompressedInputStream((Path)status.getPath(), (Configuration)conf, (long)0L);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            if (line != null) {
                long lineSize = line.getBytes().length;
                if (lineSize > maxLineSize) {
                    maxLineSize = lineSize;
                }
                while (line != null) {
                    for (String word : line.split("\\s")) {
                        size += (long)word.getBytes().length;
                    }
                    line = reader.readLine();
                }
            }
            reader.close();
        }
        Assert.assertTrue((size >= dataSize ? 1 : 0) != 0);
        Assert.assertTrue((size <= dataSize + maxLineSize ? 1 : 0) != 0);
    }

    private static void runDataGenJob(Configuration conf, Path tempDir) throws IOException, ClassNotFoundException, InterruptedException {
        JobClient client = new JobClient(conf);
        conf.setInt("mapreduce.job.maps", 1);
        Job job = Job.getInstance((Configuration)conf);
        CompressionEmulationUtil.configure((Job)job);
        job.setInputFormatClass(CustomInputFormat.class);
        org.apache.hadoop.mapreduce.lib.output.FileOutputFormat.setOutputPath((Job)job, (Path)tempDir);
        job.submit();
        int ret = job.waitForCompletion(true) ? 0 : 1;
        Assert.assertEquals((String)"Job Failed", (long)0L, (long)ret);
    }

    private void testCompressionRatioConfigure(float ratio) throws Exception {
        long dataSize = 0xA00000L;
        Configuration conf = new Configuration();
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        CompressionEmulationUtil.setInputCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setLong("gridmix.gen.bytes", dataSize);
        conf.set("mapreduce.job.hdfs-servers", "");
        float expectedRatio = 0.5f;
        if (ratio > 0.0f) {
            CompressionEmulationUtil.setMapInputCompressionEmulationRatio((Configuration)conf, (float)ratio);
            expectedRatio = CompressionEmulationUtil.standardizeCompressionRatio((float)ratio);
        }
        CompressionEmulationUtil.setupDataGeneratorConfig((Configuration)conf);
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path tempDir = new Path(rootTempDir, "TestCustomRandomCompressedTextDataGenr");
        lfs.delete(tempDir, true);
        TestCompressionEmulationUtils.runDataGenJob((Configuration)conf, (Path)tempDir);
        FileStatus[] files = lfs.listStatus(tempDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter());
        long size = 0L;
        for (FileStatus status : files) {
            size += status.getLen();
        }
        float compressionRatio = (float)size / (float)dataSize;
        float stdRatio = CompressionEmulationUtil.standardizeCompressionRatio((float)compressionRatio);
        Assert.assertEquals((double)expectedRatio, (double)stdRatio, (double)0.0);
    }

    @Test
    public void testCompressionRatios() throws Exception {
        this.testCompressionRatioConfigure(0.0f);
        this.testCompressionRatioConfigure(0.2f);
        this.testCompressionRatioConfigure(0.4f);
        this.testCompressionRatioConfigure(0.65f);
        this.testCompressionRatioConfigure(0.682f);
        this.testCompressionRatioConfigure(0.567f);
        boolean failed = false;
        try {
            this.testCompressionRatioConfigure(0.01f);
        }
        catch (RuntimeException re) {
            failed = true;
        }
        Assert.assertTrue((String)"Compression ratio min value (0.07) check failed!", (boolean)failed);
        failed = false;
        try {
            this.testCompressionRatioConfigure(0.7f);
        }
        catch (RuntimeException re) {
            failed = true;
        }
        Assert.assertTrue((String)"Compression ratio max value (0.68) check failed!", (boolean)failed);
    }

    @Test
    public void testCompressionRatioStandardization() throws Exception {
        Assert.assertEquals((double)0.55f, (double)CompressionEmulationUtil.standardizeCompressionRatio((float)0.55f), (double)0.0);
        Assert.assertEquals((double)0.65f, (double)CompressionEmulationUtil.standardizeCompressionRatio((float)0.652f), (double)0.0);
        Assert.assertEquals((double)0.78f, (double)CompressionEmulationUtil.standardizeCompressionRatio((float)0.777f), (double)0.0);
        Assert.assertEquals((double)0.86f, (double)CompressionEmulationUtil.standardizeCompressionRatio((float)0.855f), (double)0.0);
    }

    @Test
    public void testInputCompressionRatioConfiguration() throws Exception {
        Configuration conf = new Configuration();
        float ratio = 0.567f;
        CompressionEmulationUtil.setMapInputCompressionEmulationRatio((Configuration)conf, (float)ratio);
        Assert.assertEquals((double)ratio, (double)CompressionEmulationUtil.getMapInputCompressionEmulationRatio((Configuration)conf), (double)0.0);
    }

    @Test
    public void testIntermediateCompressionRatioConfiguration() throws Exception {
        Configuration conf = new Configuration();
        float ratio = 0.567f;
        CompressionEmulationUtil.setMapOutputCompressionEmulationRatio((Configuration)conf, (float)ratio);
        Assert.assertEquals((double)ratio, (double)CompressionEmulationUtil.getMapOutputCompressionEmulationRatio((Configuration)conf), (double)0.0);
    }

    @Test
    public void testOutputCompressionRatioConfiguration() throws Exception {
        Configuration conf = new Configuration();
        float ratio = 0.567f;
        CompressionEmulationUtil.setJobOutputCompressionEmulationRatio((Configuration)conf, (float)ratio);
        Assert.assertEquals((double)ratio, (double)CompressionEmulationUtil.getJobOutputCompressionEmulationRatio((Configuration)conf), (double)0.0);
    }

    @Test
    public void testCompressibleGridmixRecord() throws IOException {
        JobConf conf = new JobConf();
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        CompressionEmulationUtil.setInputCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        int dataSize = 0xA00000;
        float ratio = 0.357f;
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path tempDir = new Path(rootTempDir, "TestPossiblyCompressibleGridmixRecord");
        lfs.delete(tempDir, true);
        GridmixRecord record = new GridmixRecord(dataSize, 0L);
        record.setCompressibility(true, ratio);
        conf.setClass("mapreduce.output.fileoutputformat.compress.codec", GzipCodec.class, CompressionCodec.class);
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)true);
        Path recordFile = new Path(tempDir, "record");
        OutputStream outStream = CompressionEmulationUtil.getPossiblyCompressedOutputStream((Path)recordFile, (Configuration)conf);
        DataOutputStream out = new DataOutputStream(outStream);
        record.write((DataOutput)out);
        out.close();
        outStream.close();
        Path actualRecordFile = recordFile.suffix(".gz");
        InputStream in = CompressionEmulationUtil.getPossiblyDecompressedInputStream((Path)actualRecordFile, (Configuration)conf, (long)0L);
        long compressedFileSize = lfs.listStatus(actualRecordFile)[0].getLen();
        GridmixRecord recordRead = new GridmixRecord();
        recordRead.readFields((DataInput)new DataInputStream(in));
        Assert.assertEquals((String)"Record size mismatch in a compressible GridmixRecord", (long)dataSize, (long)recordRead.getSize());
        Assert.assertTrue((String)"Failed to generate a compressible GridmixRecord", ((long)recordRead.getSize() > compressedFileSize ? 1 : 0) != 0);
        float seenRatio = (float)compressedFileSize / (float)dataSize;
        Assert.assertEquals((double)CompressionEmulationUtil.standardizeCompressionRatio((float)ratio), (double)CompressionEmulationUtil.standardizeCompressionRatio((float)seenRatio), (double)1.0);
    }

    @Test
    public void testIsCompressionEmulationEnabled() {
        Configuration conf = new Configuration();
        Assert.assertTrue((boolean)CompressionEmulationUtil.isCompressionEmulationEnabled((Configuration)conf));
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)false);
        Assert.assertFalse((boolean)CompressionEmulationUtil.isCompressionEmulationEnabled((Configuration)conf));
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)CompressionEmulationUtil.isCompressionEmulationEnabled((Configuration)conf));
    }

    @Test
    public void testPossiblyCompressedDecompressedStreams() throws IOException {
        JobConf conf = new JobConf();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        String inputLine = "Hi Hello!";
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        CompressionEmulationUtil.setInputCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
        conf.setClass("mapreduce.output.fileoutputformat.compress.codec", GzipCodec.class, CompressionCodec.class);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path tempDir = new Path(rootTempDir, "TestPossiblyCompressedDecompressedStreams");
        lfs.delete(tempDir, true);
        Path compressedFile = new Path(tempDir, "test");
        OutputStream out = CompressionEmulationUtil.getPossiblyCompressedOutputStream((Path)compressedFile, (Configuration)conf);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        writer.write(inputLine);
        writer.close();
        compressedFile = compressedFile.suffix(".gz");
        InputStream in = CompressionEmulationUtil.getPossiblyDecompressedInputStream((Path)compressedFile, (Configuration)conf, (long)0L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String readLine = reader.readLine();
        Assert.assertEquals((String)"Compression/Decompression error", (Object)inputLine, (Object)readLine);
        reader.close();
    }

    @Test
    public void testExtractCompressionConfigs() {
        JobConf source = new JobConf();
        JobConf target = new JobConf();
        source.setBoolean("mapreduce.output.fileoutputformat.compress", false);
        source.set("mapreduce.output.fileoutputformat.compress.codec", "MyDefaultCodec");
        source.set("mapreduce.output.fileoutputformat.compress.type", "MyDefaultType");
        source.setBoolean("mapreduce.map.output.compress", false);
        source.set("mapreduce.map.output.compress.codec", "MyDefaultCodec2");
        CompressionEmulationUtil.configureCompressionEmulation((Configuration)source, (Configuration)target);
        Assert.assertFalse((boolean)target.getBoolean("mapreduce.output.fileoutputformat.compress", true));
        Assert.assertEquals((Object)"MyDefaultCodec", (Object)target.get("mapreduce.output.fileoutputformat.compress.codec"));
        Assert.assertEquals((Object)"MyDefaultType", (Object)target.get("mapreduce.output.fileoutputformat.compress.type"));
        Assert.assertFalse((boolean)target.getBoolean("mapreduce.map.output.compress", true));
        Assert.assertEquals((Object)"MyDefaultCodec2", (Object)target.get("mapreduce.map.output.compress.codec"));
        Assert.assertFalse((boolean)CompressionEmulationUtil.isInputCompressionEmulationEnabled((Configuration)target));
        source.setBoolean("mapreduce.output.fileoutputformat.compress", true);
        source.set("mapreduce.output.fileoutputformat.compress.codec", "MyCodec");
        source.set("mapreduce.output.fileoutputformat.compress.type", "MyType");
        source.setBoolean("mapreduce.map.output.compress", true);
        source.set("mapreduce.map.output.compress.codec", "MyCodec2");
        FileInputFormat.setInputPaths((JobConf)source, (String)"file.gz");
        target = new JobConf();
        CompressionEmulationUtil.configureCompressionEmulation((Configuration)source, (Configuration)target);
        Assert.assertTrue((boolean)target.getBoolean("mapreduce.output.fileoutputformat.compress", false));
        Assert.assertEquals((Object)"MyCodec", (Object)target.get("mapreduce.output.fileoutputformat.compress.codec"));
        Assert.assertEquals((Object)"MyType", (Object)target.get("mapreduce.output.fileoutputformat.compress.type"));
        Assert.assertTrue((boolean)target.getBoolean("mapreduce.map.output.compress", false));
        Assert.assertEquals((Object)"MyCodec2", (Object)target.get("mapreduce.map.output.compress.codec"));
        Assert.assertTrue((boolean)CompressionEmulationUtil.isInputCompressionEmulationEnabled((Configuration)target));
    }

    @Test
    public void testFileQueueDecompression() throws IOException {
        JobConf conf = new JobConf();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        String inputLine = "Hi Hello!";
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        CompressionEmulationUtil.setInputCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((JobConf)conf, GzipCodec.class);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(lfs.getUri(), lfs.getWorkingDirectory());
        Path tempDir = new Path(rootTempDir, "TestFileQueueDecompression");
        lfs.delete(tempDir, true);
        Path compressedFile = new Path(tempDir, "test");
        OutputStream out = CompressionEmulationUtil.getPossiblyCompressedOutputStream((Path)compressedFile, (Configuration)conf);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        writer.write(inputLine);
        writer.close();
        compressedFile = compressedFile.suffix(".gz");
        long fileSize = lfs.listStatus(compressedFile)[0].getLen();
        CombineFileSplit split = new CombineFileSplit(new Path[]{compressedFile}, new long[]{fileSize});
        FileQueue queue = new FileQueue(split, (Configuration)conf);
        byte[] bytes = new byte[inputLine.getBytes().length];
        queue.read(bytes);
        queue.close();
        String readLine = new String(bytes);
        Assert.assertEquals((String)"Compression/Decompression error", (Object)inputLine, (Object)readLine);
    }

    @Test
    public void testComputeUncompressedInputBytes() {
        long possiblyCompressedInputBytes = 100000L;
        float compressionRatio = 0.45f;
        Configuration conf = new Configuration();
        CompressionEmulationUtil.setMapInputCompressionEmulationRatio((Configuration)conf, (float)compressionRatio);
        long result = CompressionEmulationUtil.getUncompressedInputBytes((long)possiblyCompressedInputBytes, (Configuration)conf);
        Assert.assertEquals((long)possiblyCompressedInputBytes, (long)result);
        CompressionEmulationUtil.setInputCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        result = CompressionEmulationUtil.getUncompressedInputBytes((long)possiblyCompressedInputBytes, (Configuration)conf);
        Assert.assertEquals((long)((long)((float)possiblyCompressedInputBytes / compressionRatio)), (long)result);
    }
}

