/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.PseudoLocalFs;
import org.junit.Assert;
import org.junit.Test;

public class TestPseudoLocalFs {
    @Test
    public void testPseudoLocalFsFileSize() throws Exception {
        long fileSize = 10000L;
        Path path = PseudoLocalFs.generateFilePath((String)"myPsedoFile", (long)fileSize);
        PseudoLocalFs pfs = new PseudoLocalFs();
        pfs.create(path);
        FSDataInputStream in = pfs.open(path, 0);
        long totalSize = 0L;
        while (in.read() >= 0) {
            ++totalSize;
        }
        in.close();
        Assert.assertEquals((String)"File size mismatch with read().", (long)fileSize, (long)totalSize);
        in = pfs.open(path, 0);
        totalSize = 0L;
        byte[] b = new byte[1024];
        int bytesRead = in.read(b);
        while (bytesRead >= 0) {
            totalSize += (long)bytesRead;
            bytesRead = in.read(b);
        }
        Assert.assertEquals((String)"File size mismatch with read(byte[]).", (long)fileSize, (long)totalSize);
    }

    private void validateGetFileStatus(FileSystem pfs, Path path, boolean shouldSucceed) throws IOException {
        boolean expectedExceptionSeen = false;
        FileStatus stat = null;
        try {
            stat = pfs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            expectedExceptionSeen = true;
        }
        if (shouldSucceed) {
            Assert.assertFalse((String)("getFileStatus() has thrown Exception for valid file name " + path), (boolean)expectedExceptionSeen);
            Assert.assertNotNull((String)"Missing file status for a valid file.", (Object)stat);
            String[] parts = path.toUri().getPath().split("\\.");
            long expectedFileSize = Long.valueOf(parts[parts.length - 1]);
            Assert.assertEquals((String)"Invalid file size.", (long)expectedFileSize, (long)stat.getLen());
        } else {
            Assert.assertTrue((String)("getFileStatus() did not throw Exception for invalid file  name " + path), (boolean)expectedExceptionSeen);
        }
    }

    private void validateCreate(FileSystem pfs, Path path, boolean shouldSucceed) throws IOException {
        boolean expectedExceptionSeen = false;
        try {
            pfs.create(path);
        }
        catch (IOException e) {
            expectedExceptionSeen = true;
        }
        if (shouldSucceed) {
            Assert.assertFalse((String)("create() has thrown Exception for valid file name " + path), (boolean)expectedExceptionSeen);
        } else {
            Assert.assertTrue((String)("create() did not throw Exception for invalid file name " + path), (boolean)expectedExceptionSeen);
        }
    }

    private void validateOpen(FileSystem pfs, Path path, boolean shouldSucceed) throws IOException {
        boolean expectedExceptionSeen = false;
        try {
            pfs.open(path);
        }
        catch (IOException e) {
            expectedExceptionSeen = true;
        }
        if (shouldSucceed) {
            Assert.assertFalse((String)("open() has thrown Exception for valid file name " + path), (boolean)expectedExceptionSeen);
        } else {
            Assert.assertTrue((String)("open() did not throw Exception for invalid file name " + path), (boolean)expectedExceptionSeen);
        }
    }

    private void validateExists(FileSystem pfs, Path path, boolean shouldSucceed) throws IOException {
        boolean ret = pfs.exists(path);
        if (shouldSucceed) {
            Assert.assertTrue((String)("exists() returned false for valid file name " + path), (boolean)ret);
        } else {
            Assert.assertFalse((String)("exists() returned true for invalid file name " + path), (boolean)ret);
        }
    }

    @Test
    public void testPseudoLocalFsFileNames() throws IOException {
        PseudoLocalFs pfs = new PseudoLocalFs();
        Configuration conf = new Configuration();
        conf.setClass("fs.pseudo.impl", PseudoLocalFs.class, FileSystem.class);
        Path path = new Path("pseudo:///myPsedoFile.1234");
        FileSystem testFs = path.getFileSystem(conf);
        Assert.assertEquals((String)"Failed to obtain a pseudo local file system object from path", (Object)pfs.getUri().getScheme(), (Object)testFs.getUri().getScheme());
        path = new Path("file:///myPsedoFile.12345");
        this.validateGetFileStatus((FileSystem)pfs, path, false);
        this.validateCreate((FileSystem)pfs, path, false);
        this.validateOpen((FileSystem)pfs, path, false);
        this.validateExists((FileSystem)pfs, path, false);
        path = new Path("pseudo:///myPsedoFile");
        this.validateGetFileStatus((FileSystem)pfs, path, false);
        this.validateCreate((FileSystem)pfs, path, false);
        this.validateOpen((FileSystem)pfs, path, false);
        this.validateExists((FileSystem)pfs, path, false);
        path = new Path("pseudo:///myPsedoFile.txt");
        this.validateGetFileStatus((FileSystem)pfs, path, false);
        this.validateCreate((FileSystem)pfs, path, false);
        this.validateOpen((FileSystem)pfs, path, false);
        this.validateExists((FileSystem)pfs, path, false);
        long fileSize = 231456L;
        path = PseudoLocalFs.generateFilePath((String)"my.Psedo.File", (long)fileSize);
        Assert.assertEquals((String)"generateFilePath() failed.", (long)fileSize, (long)pfs.validateFileNameFormat(path));
        this.validateGetFileStatus((FileSystem)pfs, path, true);
        this.validateCreate((FileSystem)pfs, path, true);
        this.validateOpen((FileSystem)pfs, path, true);
        this.validateExists((FileSystem)pfs, path, true);
        path = new Path("myPsedoFile.1237");
        path = path.makeQualified((FileSystem)pfs);
        this.validateGetFileStatus((FileSystem)pfs, path, true);
        this.validateCreate((FileSystem)pfs, path, true);
        this.validateOpen((FileSystem)pfs, path, true);
        this.validateExists((FileSystem)pfs, path, true);
    }
}

