/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDiskError {
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdown() throws Exception {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return;
        }
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        boolean dnIndex = false;
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        File storageDir = this.cluster.getInstanceStorageDir(0, 0);
        File dir1 = MiniDFSCluster.getRbwDir(storageDir, bpid);
        storageDir = this.cluster.getInstanceStorageDir(0, 1);
        File dir2 = MiniDFSCluster.getRbwDir(storageDir, bpid);
        try {
            Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dir1.setReadOnly());
            Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dir2.setReadOnly());
            DataNode dn = this.cluster.getDataNodes().get(0);
            int i = 0;
            while (dn.isDatanodeUp()) {
                Path fileName = new Path("/test.txt" + i);
                DFSTestUtil.createFile(this.fs, fileName, 1024L, (short)2, 1L);
                DFSTestUtil.waitReplication(this.fs, fileName, (short)2);
                this.fs.delete(fileName, true);
                ++i;
            }
        }
        finally {
            FileUtil.setWritable((File)dir1, (boolean)true);
            FileUtil.setWritable((File)dir2, (boolean)true);
        }
    }

    @Test
    public void testReplicationError() throws Exception {
        Path fileName = new Path("/test.txt");
        boolean fileLen = true;
        DFSTestUtil.createFile(this.fs, fileName, 1L, (short)1, 1L);
        DFSTestUtil.waitReplication(this.fs, fileName, (short)1);
        LocatedBlocks blocks = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(), fileName.toString(), 0L, 1L);
        Assert.assertEquals((String)"Should only find 1 block", (long)blocks.locatedBlockCount(), (long)1L);
        LocatedBlock block = blocks.get(0);
        this.cluster.startDataNodes(this.conf, 1, true, null, null);
        this.cluster.waitActive();
        boolean sndNode = true;
        DataNode datanode = this.cluster.getDataNodes().get(1);
        InetSocketAddress target = datanode.getXferAddress();
        Socket s = new Socket(target.getAddress(), target.getPort());
        DataOutputStream out = new DataOutputStream(s.getOutputStream());
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512);
        new Sender(out).writeBlock(block.getBlock(), StorageType.DEFAULT, BlockTokenSecretManager.DUMMY_TOKEN, "", new DatanodeInfo[0], new StorageType[0], null, BlockConstructionStage.PIPELINE_SETUP_CREATE, 1, 0L, 0L, 0L, checksum, CachingStrategy.newDefaultStrategy(), false, false, null);
        out.flush();
        out.close();
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        File storageDir = this.cluster.getInstanceStorageDir(1, 0);
        File dir1 = MiniDFSCluster.getRbwDir(storageDir, bpid);
        storageDir = this.cluster.getInstanceStorageDir(1, 1);
        File dir2 = MiniDFSCluster.getRbwDir(storageDir, bpid);
        while (dir1.listFiles().length != 0 || dir2.listFiles().length != 0) {
            Thread.sleep(100L);
        }
        this.fs.setReplication(fileName, (short)2);
        DFSTestUtil.waitReplication(this.fs, fileName, (short)1);
        this.fs.delete(fileName, false);
    }

    @Test
    public void testLocalDirs() throws Exception {
        Configuration conf = new Configuration();
        String permStr = conf.get("dfs.datanode.data.dir.perm");
        FsPermission expected = new FsPermission(permStr);
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        for (DataNode dn : this.cluster.getDataNodes()) {
            for (FsVolumeSpi v : dn.getFSDataset().getVolumes()) {
                String dir = v.getBasePath();
                Path dataDir = new Path(dir);
                FsPermission actual = localFS.getFileStatus(dataDir).getPermission();
                Assert.assertEquals((String)("Permission for dir: " + dataDir + ", is " + actual + ", while expected is " + expected), (Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testcheckDiskError() throws IOException, InterruptedException {
        if (this.cluster.getDataNodes().size() <= 0) {
            this.cluster.startDataNodes(this.conf, 1, true, null, null);
            this.cluster.waitActive();
        }
        DataNode dataNode = this.cluster.getDataNodes().get(0);
        dataNode.getClass();
        long slackTime = 5000 / 2;
        dataNode.checkDiskErrorAsync();
        dataNode.getClass();
        Thread.sleep(5000L);
        long lastDiskErrorCheck = dataNode.getLastDiskErrorCheck();
        StringBuilder stringBuilder = new StringBuilder().append("Disk Error check is not performed within  ");
        dataNode.getClass();
        String string = stringBuilder.append(5000).append("  ms").toString();
        long l = Time.monotonicNow() - lastDiskErrorCheck;
        dataNode.getClass();
        Assert.assertTrue((String)string, (l < 5000L + slackTime ? 1 : 0) != 0);
    }

    @Test
    public void testDataTransferWhenBytesPerChecksumIsZero() throws IOException {
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        BlockScanner mockScanner = (BlockScanner)Mockito.mock(BlockScanner.class);
        Mockito.when((Object)mockScanner.isEnabled()).thenReturn((Object)false);
        dn0.setBlockScanner(mockScanner);
        Path filePath = new Path("test.dat");
        FSDataOutputStream out = this.fs.create(filePath, (short)1);
        out.write(1);
        out.hflush();
        out.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock(this.fs, filePath);
        File metadataFile = this.cluster.getBlockMetadataFile(0, block);
        RandomAccessFile raFile = new RandomAccessFile(metadataFile, "rw");
        raFile.seek(2L);
        raFile.writeByte(0);
        raFile.writeInt(0);
        raFile.close();
        String datanodeId0 = dn0.getDatanodeUuid();
        LocatedBlock lb = DFSTestUtil.getAllBlocks(this.fs, filePath).get(0);
        String storageId = lb.getStorageIDs()[0];
        this.cluster.startDataNodes(this.conf, 1, true, null, null);
        DataNode dn1 = null;
        for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
            if (this.cluster.getDataNodes().get(i).equals(datanodeId0)) continue;
            dn1 = this.cluster.getDataNodes().get(i);
            break;
        }
        DatanodeDescriptor dnd1 = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(), dn1.getDatanodeId());
        dn0.transferBlock(block, new DatanodeInfo[]{dnd1}, new StorageType[]{StorageType.DISK});
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((BlockScanner)Mockito.verify((Object)mockScanner)).markSuspectBlock((String)Mockito.eq((Object)storageId), (ExtendedBlock)Mockito.eq((Object)block));
    }
}

