/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTools {
    private static final int PIPE_BUFFER_SIZE = 5120;
    private static final String INVALID_OPTION = "-invalidOption";
    private static final String[] OPTIONS = new String[2];

    @BeforeClass
    public static void before() {
        ExitUtil.disableSystemExit();
        TestTools.OPTIONS[1] = INVALID_OPTION;
    }

    @Test
    public void testDelegationTokenFetcherPrintUsage() {
        String pattern = "Options:";
        this.checkOutput(new String[]{"-help"}, pattern, System.out, DelegationTokenFetcher.class);
    }

    @Test
    public void testDelegationTokenFetcherErrorOption() {
        String pattern = "ERROR: Only specify cancel, renew or print.";
        this.checkOutput(new String[]{"-cancel", "-renew"}, pattern, System.err, DelegationTokenFetcher.class);
    }

    @Test
    public void testJMXToolHelp() {
        String pattern = "usage: jmxget options are:";
        this.checkOutput(new String[]{"-help"}, pattern, System.out, JMXGet.class);
    }

    @Test
    public void testJMXToolAdditionParameter() {
        String pattern = "key = -addition";
        this.checkOutput(new String[]{"-service=NameNode", "-server=localhost", "-addition"}, pattern, System.err, JMXGet.class);
    }

    @Test
    public void testDFSAdminInvalidUsageHelp() {
        ImmutableSet args = ImmutableSet.of((Object)"-report", (Object)"-saveNamespace", (Object)"-rollEdits", (Object)"-restoreFailedStorage", (Object)"-refreshNodes", (Object)"-finalizeUpgrade", (Object[])new String[]{"-metasave", "-refreshUserToGroupsMappings", "-printTopology", "-refreshNamenodes", "-deleteBlockPool", "-setBalancerBandwidth", "-fetchImage"});
        try {
            for (String arg : args) {
                Assert.assertTrue((ToolRunner.run((Tool)new DFSAdmin(), (String[])TestTools.fillArgs(arg)) == -1 ? 1 : 0) != 0);
            }
            Assert.assertTrue((ToolRunner.run((Tool)new DFSAdmin(), (String[])new String[]{"-help", "-some"}) == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("testDFSAdminHelp error" + e));
        }
        String pattern = "Usage: hdfs dfsadmin";
        this.checkOutput(new String[]{"-cancel", "-renew"}, pattern, System.err, DFSAdmin.class);
    }

    private static String[] fillArgs(String arg) {
        TestTools.OPTIONS[0] = arg;
        return OPTIONS;
    }

    private void checkOutput(String[] args, String pattern, PrintStream out, Class<?> clazz) {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            PipedOutputStream pipeOut = new PipedOutputStream();
            PipedInputStream pipeIn = new PipedInputStream(pipeOut, 5120);
            if (out == System.out) {
                System.setOut(new PrintStream(pipeOut));
            } else if (out == System.err) {
                System.setErr(new PrintStream(pipeOut));
            }
            if (clazz == DelegationTokenFetcher.class) {
                TestTools.expectDelegationTokenFetcherExit(args);
            } else if (clazz == JMXGet.class) {
                TestTools.expectJMXGetExit(args);
            } else if (clazz == DFSAdmin.class) {
                this.expectDfsAdminPrint(args);
            }
            pipeOut.close();
            ByteStreams.copy((InputStream)pipeIn, (OutputStream)outBytes);
            pipeIn.close();
            Assert.assertTrue((boolean)new String(outBytes.toByteArray()).contains(pattern));
        }
        catch (Exception ex) {
            Assert.fail((String)("checkOutput error " + ex));
        }
    }

    private void expectDfsAdminPrint(String[] args) {
        try {
            ToolRunner.run((Tool)new DFSAdmin(), (String[])args);
        }
        catch (Exception ex) {
            Assert.fail((String)("expectDelegationTokenFetcherExit ex error " + ex));
        }
    }

    private static void expectDelegationTokenFetcherExit(String[] args) {
        try {
            DelegationTokenFetcher.main((String[])args);
            Assert.fail((String)"should call exit");
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.resetFirstExitException();
        }
        catch (Exception ex) {
            Assert.fail((String)("expectDelegationTokenFetcherExit ex error " + ex));
        }
    }

    private static void expectJMXGetExit(String[] args) {
        try {
            JMXGet.main((String[])args);
            Assert.fail((String)"should call exit");
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.resetFirstExitException();
        }
        catch (Exception ex) {
            Assert.fail((String)("expectJMXGetExit ex error " + ex));
        }
    }
}

