/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.HistoryEventEmitter;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.tools.rumen.SingleEventEmitter;
import org.apache.hadoop.tools.rumen.TaskAttempt20LineEventEmitter;

public class ReduceAttempt20LineHistoryEventEmitter
extends TaskAttempt20LineEventEmitter {
    static List<SingleEventEmitter> nonFinals = new LinkedList<SingleEventEmitter>();
    static List<SingleEventEmitter> finals = new LinkedList<SingleEventEmitter>();

    ReduceAttempt20LineHistoryEventEmitter() {
    }

    @Override
    List<SingleEventEmitter> finalSEEs() {
        return finals;
    }

    @Override
    List<SingleEventEmitter> nonFinalSEEs() {
        return nonFinals;
    }

    static {
        nonFinals.addAll(taskEventNonFinalSEEs);
        finals.add(new ReduceAttemptFinishedEventEmitter());
    }

    private static class ReduceAttemptFinishedEventEmitter
    extends SingleEventEmitter {
        private ReduceAttemptFinishedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String taskAttemptIDName, HistoryEventEmitter thatg) {
            if (taskAttemptIDName == null) {
                return null;
            }
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)taskAttemptIDName);
            String finishTime = line.get("FINISH_TIME");
            String status = line.get("TASK_STATUS");
            if (finishTime != null && status != null && status.equalsIgnoreCase("success")) {
                String hostName = line.get("HOSTNAME");
                String counters = line.get("COUNTERS");
                String state = line.get("STATE_STRING");
                String shuffleFinish = line.get("SHUFFLE_FINISHED");
                String sortFinish = line.get("SORT_FINISHED");
                if (shuffleFinish != null && sortFinish != null && "success".equalsIgnoreCase(status)) {
                    ReduceAttempt20LineHistoryEventEmitter that = (ReduceAttempt20LineHistoryEventEmitter)thatg;
                    return new ReduceAttemptFinishedEvent(taskAttemptID, that.originalTaskType, status, Long.parseLong(shuffleFinish), Long.parseLong(sortFinish), Long.parseLong(finishTime), hostName, -1, null, state, HistoryEventEmitter.maybeParseCounters(counters), (int[][])null);
                }
            }
            return null;
        }
    }
}

