/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.appmaster;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.TaskRunner;
import org.apache.hadoop.yarn.sls.utils.SLSUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class AMSimulator
extends TaskRunner.Task {
    protected ResourceManager rm;
    protected SLSRunner se;
    protected ApplicationId appId;
    protected ApplicationAttemptId appAttemptId;
    protected String oldAppId;
    protected static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected final BlockingQueue<AllocateResponse> responseQueue;
    protected int RESPONSE_ID = 1;
    protected String user;
    protected String queue;
    protected String amtype;
    protected long traceStartTimeMS;
    protected long traceFinishTimeMS;
    protected long simulateStartTimeMS;
    protected long simulateFinishTimeMS;
    protected boolean isTracked;
    protected int totalContainers;
    protected int finishedContainers;
    protected final Logger LOG = Logger.getLogger(AMSimulator.class);

    public AMSimulator() {
        this.responseQueue = new LinkedBlockingQueue<AllocateResponse>();
    }

    public void init(int id, int heartbeatInterval, List<ContainerSimulator> containerList, ResourceManager rm, SLSRunner se, long traceStartTime, long traceFinishTime, String user, String queue, boolean isTracked, String oldAppId) {
        super.init(traceStartTime, traceStartTime + 1000000L * (long)heartbeatInterval, heartbeatInterval);
        this.user = user;
        this.rm = rm;
        this.se = se;
        this.user = user;
        this.queue = queue;
        this.oldAppId = oldAppId;
        this.isTracked = isTracked;
        this.traceStartTimeMS = traceStartTime;
        this.traceFinishTimeMS = traceFinishTime;
    }

    @Override
    public void firstStep() throws Exception {
        this.simulateStartTimeMS = System.currentTimeMillis() - SLSRunner.getRunner().getStartTimeMS();
        this.submitApp();
        this.registerAM();
        this.trackApp();
    }

    @Override
    public void middleStep() throws Exception {
        this.processResponseQueue();
        this.sendContainerRequest();
        this.checkStop();
    }

    @Override
    public void lastStep() throws Exception {
        this.LOG.info((Object)MessageFormat.format("Application {0} is shutting down.", this.appId));
        if (this.isTracked) {
            this.untrackApp();
        }
        final FinishApplicationMasterRequest finishAMRequest = (FinishApplicationMasterRequest)recordFactory.newRecordInstance(FinishApplicationMasterRequest.class);
        finishAMRequest.setFinalApplicationStatus(FinalApplicationStatus.SUCCEEDED);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appId)).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                AMSimulator.this.rm.getApplicationMasterService().finishApplicationMaster(finishAMRequest);
                return null;
            }
        });
        this.simulateFinishTimeMS = System.currentTimeMillis() - SLSRunner.getRunner().getStartTimeMS();
        ((SchedulerWrapper)this.rm.getResourceScheduler()).addAMRuntime(this.appId, this.traceStartTimeMS, this.traceFinishTimeMS, this.simulateStartTimeMS, this.simulateFinishTimeMS);
    }

    protected ResourceRequest createResourceRequest(Resource resource, String host, int priority, int numContainers) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(resource);
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        Priority prio = (Priority)recordFactory.newRecordInstance(Priority.class);
        prio.setPriority(priority);
        request.setPriority(prio);
        return request;
    }

    protected AllocateRequest createAllocateRequest(List<ResourceRequest> ask, List<ContainerId> toRelease) {
        AllocateRequest allocateRequest = (AllocateRequest)recordFactory.newRecordInstance(AllocateRequest.class);
        allocateRequest.setResponseId(this.RESPONSE_ID++);
        allocateRequest.setAskList(ask);
        allocateRequest.setReleaseList(toRelease);
        return allocateRequest;
    }

    protected AllocateRequest createAllocateRequest(List<ResourceRequest> ask) {
        return this.createAllocateRequest(ask, new ArrayList<ContainerId>());
    }

    protected abstract void processResponseQueue() throws Exception;

    protected abstract void sendContainerRequest() throws Exception;

    protected abstract void checkStop();

    private void submitApp() throws YarnException, InterruptedException, IOException {
        GetNewApplicationRequest newAppRequest = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        GetNewApplicationResponse newAppResponse = this.rm.getClientRMService().getNewApplication(newAppRequest);
        this.appId = newAppResponse.getApplicationId();
        final SubmitApplicationRequest subAppRequest = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext appSubContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appSubContext.setApplicationId(this.appId);
        appSubContext.setMaxAppAttempts(1);
        appSubContext.setQueue(this.queue);
        appSubContext.setPriority(Priority.newInstance((int)0));
        ContainerLaunchContext conLauContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        conLauContext.setApplicationACLs(new HashMap());
        conLauContext.setCommands(new ArrayList());
        conLauContext.setEnvironment(new HashMap());
        conLauContext.setLocalResources(new HashMap());
        conLauContext.setServiceData(new HashMap());
        appSubContext.setAMContainerSpec(conLauContext);
        appSubContext.setUnmanagedAM(true);
        subAppRequest.setApplicationSubmissionContext(appSubContext);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.user);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws YarnException {
                AMSimulator.this.rm.getClientRMService().submitApplication(subAppRequest);
                return null;
            }
        });
        this.LOG.info((Object)MessageFormat.format("Submit a new application {0}", this.appId));
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(this.appId);
        while (app.getState() != RMAppState.ACCEPTED) {
            Thread.sleep(10L);
        }
        this.appAttemptId = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appId)).getCurrentAppAttempt().getAppAttemptId();
        RMAppAttempt rmAppAttempt = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appId)).getCurrentAppAttempt();
        while (rmAppAttempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED) {
            Thread.sleep(10L);
        }
    }

    private void registerAM() throws YarnException, IOException, InterruptedException {
        final RegisterApplicationMasterRequest amRegisterRequest = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        amRegisterRequest.setHost("localhost");
        amRegisterRequest.setRpcPort(1000);
        amRegisterRequest.setTrackingUrl("localhost:1000");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appId)).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RegisterApplicationMasterResponse>(){

            @Override
            public RegisterApplicationMasterResponse run() throws Exception {
                return AMSimulator.this.rm.getApplicationMasterService().registerApplicationMaster(amRegisterRequest);
            }
        });
        this.LOG.info((Object)MessageFormat.format("Register the application master for application {0}", this.appId));
    }

    private void trackApp() {
        if (this.isTracked) {
            ((SchedulerWrapper)this.rm.getResourceScheduler()).addTrackedApp(this.appAttemptId, this.oldAppId);
        }
    }

    public void untrackApp() {
        if (this.isTracked) {
            ((SchedulerWrapper)this.rm.getResourceScheduler()).removeTrackedApp(this.appAttemptId, this.oldAppId);
        }
    }

    protected List<ResourceRequest> packageRequests(List<ContainerSimulator> csList, int priority) {
        HashMap<String, ResourceRequest> rackLocalRequestMap = new HashMap<String, ResourceRequest>();
        HashMap<String, ResourceRequest> nodeLocalRequestMap = new HashMap<String, ResourceRequest>();
        ResourceRequest anyRequest = null;
        for (ContainerSimulator cs : csList) {
            String[] rackHostNames = SLSUtils.getRackHostName(cs.getHostname());
            String rackname = rackHostNames[0];
            if (rackLocalRequestMap.containsKey(rackname)) {
                ((ResourceRequest)rackLocalRequestMap.get(rackname)).setNumContainers(((ResourceRequest)rackLocalRequestMap.get(rackname)).getNumContainers() + 1);
            } else {
                ResourceRequest request = this.createResourceRequest(cs.getResource(), rackname, priority, 1);
                rackLocalRequestMap.put(rackname, request);
            }
            String hostname = rackHostNames[1];
            if (nodeLocalRequestMap.containsKey(hostname)) {
                ((ResourceRequest)nodeLocalRequestMap.get(hostname)).setNumContainers(((ResourceRequest)nodeLocalRequestMap.get(hostname)).getNumContainers() + 1);
            } else {
                ResourceRequest request = this.createResourceRequest(cs.getResource(), hostname, priority, 1);
                nodeLocalRequestMap.put(hostname, request);
            }
            if (anyRequest == null) {
                anyRequest = this.createResourceRequest(cs.getResource(), "*", priority, 1);
                continue;
            }
            anyRequest.setNumContainers(anyRequest.getNumContainers() + 1);
        }
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.addAll(nodeLocalRequestMap.values());
        ask.addAll(rackLocalRequestMap.values());
        if (anyRequest != null) {
            ask.add(anyRequest);
        }
        return ask;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getAMType() {
        return this.amtype;
    }

    public long getDuration() {
        return this.simulateFinishTimeMS - this.simulateStartTimeMS;
    }

    public int getNumTasks() {
        return this.totalContainers;
    }
}

