/*
 * Decompiled with CFR 0.152.
 */
package bloop.launcher;

import bloop.launcher.LauncherStatus;
import bloop.launcher.LauncherStatus$FailedToConnectToServer$;
import bloop.launcher.LauncherStatus$FailedToInstallBloop$;
import bloop.launcher.LauncherStatus$FailedToOpenBspConnection$;
import bloop.launcher.LauncherStatus$FailedToParseArguments$;
import bloop.launcher.LauncherStatus$SuccessfulRun$;
import bloop.launcher.bsp.BspBridge;
import bloop.launcher.bsp.BspConnection;
import bloop.launcher.core.AvailableAt;
import bloop.launcher.core.Feedback$;
import bloop.launcher.core.Installer$;
import bloop.launcher.core.ListeningAndAvailableAt;
import bloop.launcher.core.ResolvedAt;
import bloop.launcher.core.ServerStatus;
import bloop.launcher.core.Shell;
import bloop.launcher.package$;
import bloop.launcher.util.Environment$;
import coursier.core.Dependency;
import coursier.core.Module;
import coursier.core.Resolution;
import coursier.core.Version;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0010!\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003<\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\t\u0011=\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005%\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011\u0015A\b\u0001\"\u0001z\u0011%\tI\u0001\u0001b\u0001\n\u001b\tY\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000bQBA\u0007\u0011%\tY\u0002\u0001b\u0001\n\u001b\ti\u0002\u0003\u0005\u00022\u0001\u0001\u000bQBA\u0010\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kA\u0011\"!\u0011\u0001\u0005\u0004%i!a\u0011\t\u0011\u0005-\u0003\u0001)A\u0007\u0003\u000bBq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002\\\u0001!\t!!\u0018\u0006\r\u0005U\u0004\u0001AA<\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!!+\u0001\t\u0003\tY\u000bC\u0004\u00028\u0002!\t!!/\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\"I\u0011\u0011\u001a\u0001A\u0002\u0013%\u00111\u001a\u0005\n\u0003;\u0004\u0001\u0019!C\u0005\u0003?D\u0001\"!:\u0001A\u0003&\u0011Q\u001a\u0005\b\u0003O\u0004A\u0011AAu\u00051a\u0015-\u001e8dQ\u0016\u0014X*Y5o\u0015\t\t#%\u0001\u0005mCVt7\r[3s\u0015\u0005\u0019\u0013!\u00022m_>\u00048\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017\u0001C2mS\u0016tG/\u00138\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014AA5p\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0018\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\nG2LWM\u001c;PkR\u0004\"AL\u001c\n\u0005az#\u0001D(viB,Ho\u0015;sK\u0006l\u0017aA8viV\t1\b\u0005\u0002/y%\u0011Qh\f\u0002\f!JLg\u000e^*ue\u0016\fW.\u0001\u0003pkR\u0004\u0013aB2iCJ\u001cX\r\u001e\t\u0003\u0003\u0016k\u0011A\u0011\u0006\u0003\u007f\rS!\u0001R\u0019\u0002\u00079Lw.\u0003\u0002G\u0005\n91\t[1sg\u0016$\u0018!B:iK2dW#A%\u0011\u0005)kU\"A&\u000b\u00051\u0003\u0013\u0001B2pe\u0016L!AT&\u0003\u000bMCW\r\u001c7\u0002\rMDW\r\u001c7!\u0003-q\u0017-\u001b7hk:\u0004vN\u001d;\u0016\u0003I\u00032aJ*V\u0013\t!\u0006F\u0001\u0004PaRLwN\u001c\t\u0003OYK!a\u0016\u0015\u0003\u0007%sG/\u0001\u0007oC&dw-\u001e8Q_J$\b%A\u0007ti\u0006\u0014H/\u001a3TKJ4XM\u001d\t\u00047z\u0003W\"\u0001/\u000b\u0005uC\u0013AC2p]\u000e,(O]3oi&\u0011q\f\u0018\u0002\b!J|W.[:f!\t9\u0013-\u0003\u0002cQ\t!QK\\5u\u0003e9WM\\3sCR,'\t\\8pa&s7\u000f^1mY\u0016\u0014XK\u0015'\u0011\t\u001d*wM]\u0005\u0003M\"\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005!|gBA5n!\tQ\u0007&D\u0001l\u0015\taG%\u0001\u0004=e>|GOP\u0005\u0003]\"\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a\u000e\u000b\t\u0003gZl\u0011\u0001\u001e\u0006\u0003kF\n1A\\3u\u0013\t9HOA\u0002V%2\u000ba\u0001P5oSRtD#\u0004>}{z|\u0018\u0011AA\u0002\u0003\u000b\t9\u0001\u0005\u0002|\u00015\t\u0001\u0005C\u0003-\u0019\u0001\u0007Q\u0006C\u00036\u0019\u0001\u0007a\u0007C\u0003:\u0019\u0001\u00071\bC\u0003@\u0019\u0001\u0007\u0001\tC\u0003H\u0019\u0001\u0007\u0011\nC\u0003Q\u0019\u0001\u0007!\u000bC\u0003Z\u0019\u0001\u0007!\fC\u0003d\u0019\u0001\u0007A-\u0001\bmCVt7\r[3s)6\u0004H)\u001b:\u0016\u0005\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M1)\u0001\u0003gS2,\u0017\u0002BA\f\u0003#\u0011A\u0001U1uQ\u0006yA.Y;oG\",'\u000fV7q\t&\u0014\b%A\ncY>|\u0007/\u00113eSRLwN\\1m\u0003J<7/\u0006\u0002\u0002 A)\u0011\u0011EA\u0016O:!\u00111EA\u0014\u001d\rQ\u0017QE\u0005\u0002S%\u0019\u0011\u0011\u0006\u0015\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005%\u0002&\u0001\u000bcY>|\u0007/\u00113eSRLwN\\1m\u0003J<7\u000fI\u0001\u0005[\u0006Lg\u000eF\u0002a\u0003oAq!!\u000f\u0012\u0001\u0004\tY$\u0001\u0003be\u001e\u001c\b\u0003B\u0014\u0002>\u001dL1!a\u0010)\u0005\u0015\t%O]1z\u0003E\u00196.\u001b9CgB\u001cuN\u001c8fGRLwN\\\u000b\u0003\u0003\u000bz!!a\u0012\"\u0005\u0005%\u0013!F\u0017.g.L\u0007/\f2ta6\u001awN\u001c8fGRLwN\\\u0001\u0013'.L\u0007OQ:q\u0007>tg.Z2uS>t\u0007%A\u0002dY&$B!!\u0015\u0002XA\u001910a\u0015\n\u0007\u0005U\u0003E\u0001\bMCVt7\r[3s'R\fG/^:\t\u000f\u0005eC\u00031\u0001\u0002<\u0005)\u0011M]4ta\u0005Y!/\u001e8MCVt7\r[3s))\t\t&a\u0018\u0002d\u0005\u001d\u0014\u0011\u000f\u0005\u0007\u0003C*\u0002\u0019A4\u0002+\tdwn\u001c9WKJ\u001c\u0018n\u001c8U_&s7\u000f^1mY\"1\u0011QM\u000bA\u0002I\f\u0011C\u00197p_BLen\u001d;bY2,'/\u0016*M\u0011\u001d\tI'\u0006a\u0001\u0003W\n\u0011c]6ja\n\u001b\boQ8o]\u0016\u001cG/[8o!\r9\u0013QN\u0005\u0004\u0003_B#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003g*\u0002\u0019AA\u0010\u0003A\u0019XM\u001d<fe*3Xn\u00149uS>t7O\u0001\tD_:tWm\u0019;j_:\u0014Vm];miB9\u0011\u0011EA=A\u0006u\u0014\u0002BA>\u0003_\u0011a!R5uQ\u0016\u0014\b\u0003B\u0014T\u0003\u007f\u00022a]AA\u0013\r\t\u0019\t\u001e\u0002\u0007'>\u001c7.\u001a;\u0002/\r|gN\\3diR{'\t\\8pa\n\u001b\boU3sm\u0016\u0014H\u0003DAE\u0003\u001f\u000b\u0019*!&\u0002\u0018\u0006\u001d\u0006\u0003CA\u0011\u0003s\n\t&a#\u0011\u0007\u00055e#D\u0001\u0001\u0011\u0019\t\tj\u0006a\u0001O\u0006a!\r\\8paZ+'o]5p]\"1\u0011QM\fA\u0002IDq!!\u001b\u0018\u0001\u0004\tY\u0007C\u0004\u0002\u001a^\u0001\r!a'\u0002\r\t\u0014\u0018\u000eZ4f!\u0011\ti*a)\u000e\u0005\u0005}%bAAQA\u0005\u0019!m\u001d9\n\t\u0005\u0015\u0016q\u0014\u0002\n\u0005N\u0004(I]5eO\u0016Dq!a\u001d\u0018\u0001\u0004\ty\"A\teKR,7\r^*feZ,'o\u0015;bi\u0016$B!!,\u00026B!qeUAX!\rQ\u0015\u0011W\u0005\u0004\u0003g[%\u0001D*feZ,'o\u0015;biV\u001c\bBBAI1\u0001\u0007q-A\njgZ\u000bG.\u001b3CY>|\u0007OV3sg&|g\u000e\u0006\u0003\u0002<\u0006u\u0006\u0003B\u0014T\u0003WBa!a0\u001a\u0001\u00049\u0017a\u0002<feNLwN\\\u0001\u001de\u0016\u001cwN^3s\rJ|W.\u00168j]N$\u0018\r\u001c7fIN+'O^3s)\u0019\ti+!2\u0002H\"1\u0011\u0011\u0013\u000eA\u0002\u001dDa!!\u001a\u001b\u0001\u0004\u0011\u0018\u0001\u00062m_>\u0004()Y2lOJ|WO\u001c3FeJ|'/\u0006\u0002\u0002NB!qeUAh!\u00199\u0013\u0011[4\u0002V&\u0019\u00111\u001b\u0015\u0003\rQ+\b\u000f\\33!\u0011\t9.!7\u000f\u0007\u00055e!C\u0002\u0002\\6\u0013Qb\u0015;biV\u001c8i\\7nC:$\u0017\u0001\u00072m_>\u0004()Y2lOJ|WO\u001c3FeJ|'o\u0018\u0013fcR\u0019\u0001-!9\t\u0013\u0005\rH$!AA\u0002\u00055\u0017a\u0001=%c\u0005)\"\r\\8pa\n\u000b7m[4s_VtG-\u0012:s_J\u0004\u0013\u0001I:uCJ$8+\u001a:wKJ4\u0016.Y*de&\u0004H/\u00138CC\u000e\\wM]8v]\u0012$R\u0001YAv\u0003_Dq!!<\u001f\u0001\u0004\ty\"\u0001\u0004cS:\f'/\u001f\u0005\b\u0003ct\u0002\u0019AA\u0010\u0003)Qg/\\(qi&|gn\u001d")
public class LauncherMain {
    private final InputStream clientIn;
    private final OutputStream clientOut;
    private final PrintStream out;
    private final Shell shell;
    private final Option<Object> nailgunPort;
    private final Promise<BoxedUnit> startedServer;
    private final Function1<String, URL> generateBloopInstallerURL;
    private final Path launcherTmpDir;
    private final List<String> bloopAdditionalArgs;
    private Option<Tuple2<String, Shell.StatusCommand>> bloopBackgroundError;

    public PrintStream out() {
        return this.out;
    }

    public Shell shell() {
        return this.shell;
    }

    public Option<Object> nailgunPort() {
        return this.nailgunPort;
    }

    private final Path launcherTmpDir() {
        return this.launcherTmpDir;
    }

    private final List<String> bloopAdditionalArgs() {
        return this.bloopAdditionalArgs;
    }

    public void main(String[] args) {
        LauncherStatus launcherStatus = this.cli(args);
        if (LauncherStatus$SuccessfulRun$.MODULE$.equals(launcherStatus)) {
            throw scala.sys.package$.MODULE$.exit(0);
        }
        if (launcherStatus instanceof LauncherStatus.FailedLauncherStatus) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
        throw new MatchError((Object)launcherStatus);
    }

    private final String SkipBspConnection() {
        return "--skip-bsp-connection";
    }

    public LauncherStatus cli(String[] args0) {
        LauncherStatus launcherStatus;
        Tuple2 tuple2;
        int index = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args0)).indexOf((Object)"--");
        Tuple2 tuple22 = tuple2 = index == -1 ? new Tuple2((Object)args0, Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args0)).splitAt(index);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] args = (String[])tuple2._1();
        String[] extraArgs = (String[])tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)args, (Object)extraArgs);
        Tuple2 tuple24 = tuple23;
        String[] args2 = (String[])tuple24._1();
        String[] extraArgs2 = (String[])tuple24._2();
        Tuple2 tuple25 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args2)).partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("-J")));
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        String[] jvmOptions = (String[])tuple25._1();
        String[] cliOptions = (String[])tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)jvmOptions, (Object)cliOptions);
        Tuple2 tuple27 = tuple26;
        String[] jvmOptions2 = (String[])tuple27._1();
        String[] cliOptions2 = (String[])tuple27._2();
        Tuple2 tuple28 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cliOptions2)).toList().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("--")));
        if (tuple28 == null) {
            throw new MatchError((Object)tuple28);
        }
        List cliFlags = (List)tuple28._1();
        List cliArgs = (List)tuple28._2();
        Tuple2 tuple29 = new Tuple2((Object)cliFlags, (Object)cliArgs);
        Tuple2 tuple210 = tuple29;
        List cliFlags2 = (List)tuple210._1();
        List cliArgs2 = (List)tuple210._2();
        boolean skipBspConnection = cliFlags2.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LauncherMain.$anonfun$cli$3(x$7)));
        if (cliArgs2.size() == 1) {
            String bloopVersion = (String)cliArgs2.apply(0);
            URL bloopInstallerURL = (URL)this.generateBloopInstallerURL.apply((Object)bloopVersion);
            launcherStatus = this.runLauncher(bloopVersion, bloopInstallerURL, skipBspConnection, (List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jvmOptions2)).toList());
        } else {
            package$.MODULE$.printError(Feedback$.MODULE$.NoBloopVersion(), this.out());
            launcherStatus = LauncherStatus$FailedToParseArguments$.MODULE$;
        }
        return launcherStatus;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LauncherStatus runLauncher(String bloopVersionToInstall, URL bloopInstallerURL, boolean skipBspConnection, List<String> serverJvmOptions) {
        Right right;
        Option option;
        Either either;
        Right right2;
        Option option2;
        Either either2;
        void var5_14;
        package$.MODULE$.println("Starting the bsp launcher for bloop...", this.out());
        BspBridge bridge = new BspBridge(this.clientIn, this.clientOut, this.startedServer, this.out(), this.shell(), this.launcherTmpDir());
        boolean bl = false;
        Right right3 = null;
        Either<LauncherStatus, Either<BoxedUnit, Option<Socket>>> either3 = this.connectToBloopBspServer(bloopVersionToInstall, bloopInstallerURL, skipBspConnection, bridge, serverJvmOptions);
        if (either3 instanceof Right) {
            bl = true;
            right3 = (Right)either3;
            Either either4 = (Either)right3.value();
            if (either4 instanceof Left) {
                LauncherStatus$SuccessfulRun$ launcherStatus$SuccessfulRun$ = LauncherStatus$SuccessfulRun$.MODULE$;
                return var5_14;
            }
        }
        if (bl && (either2 = (Either)right3.value()) instanceof Right && (option2 = (Option)(right2 = (Right)either2).value()) instanceof Some) {
            Some some = (Some)option2;
            Socket socket = (Socket)some.value();
            bridge.wireBspConnectionStreams(socket);
            LauncherStatus$SuccessfulRun$ launcherStatus$SuccessfulRun$ = LauncherStatus$SuccessfulRun$.MODULE$;
            return var5_14;
        }
        if (bl && (either = (Either)right3.value()) instanceof Right && None$.MODULE$.equals(option = (Option)(right = (Right)either).value())) {
            this.failPromise$1(LauncherStatus$FailedToOpenBspConnection$.MODULE$);
            LauncherStatus$FailedToOpenBspConnection$ launcherStatus$FailedToOpenBspConnection$ = LauncherStatus$FailedToOpenBspConnection$.MODULE$;
            return var5_14;
        }
        if (!(either3 instanceof Left)) throw new MatchError(either3);
        Left left = (Left)either3;
        LauncherStatus status = (LauncherStatus)left.value();
        this.failPromise$1(status);
        LauncherStatus launcherStatus = status;
        return var5_14;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<LauncherStatus, Either<BoxedUnit, Option<Socket>>> connectToBloopBspServer(String bloopVersion, URL bloopInstallerURL, boolean skipBspConnection, BspBridge bridge, List<String> serverJvmOptions) {
        ServerStatus serverStatus;
        ServerStatus serverStatus2;
        Some some;
        Option<ServerStatus> option = this.detectServerState(bloopVersion);
        if (option instanceof Some) {
            Some some2 = (Some)option;
            package$.MODULE$.println(Feedback$.MODULE$.DetectedBloopinstallation(), this.out());
            some = some2;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            some = this.recoverFromUninstalledServer(bloopVersion, bloopInstallerURL);
        }
        Some latestServerStatus = some;
        boolean bl = false;
        Some some3 = null;
        Some some4 = latestServerStatus;
        if (some4 instanceof Some) {
            bl = true;
            some3 = some4;
            ServerStatus serverStatus3 = (ServerStatus)some3.value();
            if (serverStatus3 instanceof ListeningAndAvailableAt) {
                ListeningAndAvailableAt listeningAndAvailableAt = (ListeningAndAvailableAt)serverStatus3;
                List<String> binary = listeningAndAvailableAt.binary();
                return skipBspConnection ? scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT)) : this.openBspSocket$1(false, (Function1 & Serializable & scala.Serializable)useTcp -> bridge.establishBspConnectionViaBinary((List<String>)binary, BoxesRunTime.unboxToBoolean((Object)useTcp), bridge.establishBspConnectionViaBinary$default$3()), bridge);
            }
        }
        if (bl && (serverStatus2 = (ServerStatus)some3.value()) instanceof AvailableAt) {
            Left left;
            Some some5;
            ServerStatus serverStatus4;
            Some some6;
            ServerStatus serverStatus5;
            Option<ServerStatus> option2;
            boolean bl2;
            AvailableAt availableAt = (AvailableAt)serverStatus2;
            List<String> binary = availableAt.binary();
            this.startServerViaScriptInBackground(binary, serverJvmOptions);
            package$.MODULE$.println("Server was started in a thread, waiting until it's up and running...", this.out());
            int maxAttempts = 40;
            int attempts = 1;
            LongRef totalMs = LongRef.create((long)0L);
            Option<ServerStatus> listening = None$.MODULE$;
            while (bl2 = (option2 = listening) instanceof Some && (serverStatus5 = (ServerStatus)(some6 = (Some)option2).value()) instanceof ListeningAndAvailableAt ? false : attempts <= maxAttempts) {
                long waitMs = 250;
                Thread.sleep(waitMs);
                totalMs.elem += waitMs;
                int port = BoxesRunTime.unboxToInt((Object)this.nailgunPort().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 8212));
                package$.MODULE$.println(new StringBuilder(48).append("Sleeping for ").append(waitMs).append("ms until we connect to server port ").append(port).toString(), this.out());
                listening = this.shell().connectToBloopPort(binary, port, this.out());
                ++attempts;
            }
            Option<ServerStatus> option3 = listening;
            if (option3 instanceof Some && (serverStatus4 = (ServerStatus)(some5 = (Some)option3).value()) instanceof ListeningAndAvailableAt) {
                ListeningAndAvailableAt listeningAndAvailableAt = (ListeningAndAvailableAt)serverStatus4;
                List<String> binary2 = listeningAndAvailableAt.binary();
                left = skipBspConnection ? scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT)) : this.openBspSocket$1(false, (Function1 & Serializable & scala.Serializable)forceTcp -> bridge.establishBspConnectionViaBinary((List<String>)binary2, BoxesRunTime.unboxToBoolean((Object)forceTcp), bridge.establishBspConnectionViaBinary$default$3()), bridge);
                return left;
            } else {
                left = scala.package$.MODULE$.Left().apply((Object)this.ifSessionIsLive$1((Function0 & Serializable & scala.Serializable)() -> {
                    package$.MODULE$.printError(new StringBuilder(44).append("Failed to connect to server after waiting ").append(totalMs$1.elem).append("ms").toString(), this.out());
                    return LauncherStatus$FailedToConnectToServer$.MODULE$;
                }));
            }
            return left;
        }
        if (bl && (serverStatus = (ServerStatus)some3.value()) instanceof ResolvedAt) {
            ResolvedAt resolvedAt = (ResolvedAt)serverStatus;
            Seq<Path> classpath = resolvedAt.files();
            return skipBspConnection ? scala.package$.MODULE$.Left().apply((Object)LauncherStatus$FailedToInstallBloop$.MODULE$) : this.openBspSocket$1(false, (Function1 & Serializable & scala.Serializable)forceTcp -> bridge.runEmbeddedBspInvocationInBackground((Seq<Path>)classpath, BoxesRunTime.unboxToBoolean((Object)forceTcp), (List<String>)serverJvmOptions), bridge);
        }
        if (!None$.MODULE$.equals(some4)) throw new MatchError((Object)some4);
        return scala.package$.MODULE$.Left().apply((Object)LauncherStatus$FailedToInstallBloop$.MODULE$);
    }

    public Option<ServerStatus> detectServerState(String bloopVersion) {
        return this.shell().detectBloopInSystemPath((List<String>)((List)new .colon.colon((Object)"bloop", (List)Nil$.MODULE$).$plus$plus(this.bloopAdditionalArgs(), List$.MODULE$.canBuildFrom())), this.out()).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<ServerStatus> option;
            Path homeBloopDir = Environment$.MODULE$.defaultBloopDirectory();
            if (!Files.exists(homeBloopDir, new LinkOption[0])) {
                option = None$.MODULE$;
            } else {
                String binaryName = Environment$.MODULE$.isWindows() ? "bloop.cmd" : "bloop";
                Path pybloop = homeBloopDir.resolve(binaryName);
                if (!Files.exists(pybloop, new LinkOption[0])) {
                    option = None$.MODULE$;
                } else {
                    String binaryInHome = ((Object)pybloop.normalize().toAbsolutePath()).toString();
                    option = this.shell().detectBloopInSystemPath((List<String>)((List)new .colon.colon((Object)binaryInHome, (List)Nil$.MODULE$).$plus$plus(this.bloopAdditionalArgs(), List$.MODULE$.canBuildFrom())), this.out());
                }
            }
            return option;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> isValidBloopVersion(String version) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = new Version(version).items();
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            Version.Item item = (Version.Item)colon2.head();
            List list2 = colon2.tl$access$1();
            if (item instanceof Version.Number) {
                Version.Number number = (Version.Number)item;
                int major = number.value();
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    Version.Item item2 = (Version.Item)colon3.head();
                    List list3 = colon3.tl$access$1();
                    if (item2 instanceof Version.Number) {
                        .colon.colon colon4;
                        Version.Item item3;
                        Version.Number number2 = (Version.Number)item2;
                        int minor = number2.value();
                        if (list3 instanceof .colon.colon && (item3 = (Version.Item)(colon4 = (.colon.colon)list3).head()) instanceof Version.Number) {
                            Version.Number number3 = (Version.Number)item3;
                            int patch = number3.value();
                            return new Some((Object)BoxesRunTime.boxToBoolean((major == 1 && minor == 1 && patch == 2 || major >= 1 && minor >= 2 ? 1 : 0) != 0));
                        }
                    }
                }
            }
        }
        if (bl) {
            Version.Item item = (Version.Item)colon2.head();
            List list4 = colon2.tl$access$1();
            if (item instanceof Version.Number) {
                .colon.colon colon5;
                Version.Item item4;
                Version.Number number = (Version.Number)item;
                int major = number.value();
                if (list4 instanceof .colon.colon && (item4 = (Version.Item)(colon5 = (.colon.colon)list4).head()) instanceof Version.Number) {
                    Version.Number number4 = (Version.Number)item4;
                    int minor = number4.value();
                    return new Some((Object)BoxesRunTime.boxToBoolean((major >= 1 && minor >= 2 ? 1 : 0) != 0));
                }
            }
        }
        package$.MODULE$.printError(new StringBuilder(62).append("Bloop version ").append(version).append(" does not follow semantic versioning, parsed as ").append(list).toString(), this.out());
        return None$.MODULE$;
    }

    public Option<ServerStatus> recoverFromUninstalledServer(String bloopVersion, URL bloopInstallerURL) {
        None$ none$;
        Some some;
        boolean bl;
        Option<Object> option = this.isValidBloopVersion(bloopVersion);
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            package$.MODULE$.println(Feedback$.MODULE$.installingBloop(bloopVersion), this.out());
            Option<ServerStatus> fullyInstalled = Installer$.MODULE$.installBloopBinaryInHomeDir(this.launcherTmpDir(), Environment$.MODULE$.defaultBloopDirectory(), bloopVersion, this.out(), (Function1<String, Option<ServerStatus>>)(Function1 & Serializable & scala.Serializable)x$8 -> this.detectServerState((String)x$8), this.shell(), bloopInstallerURL);
            none$ = fullyInstalled.orElse((Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                package$.MODULE$.println(Feedback$.MODULE$.UseFallbackInstallation(), this.out());
                Tuple2<Dependency, Resolution> tuple2 = Installer$.MODULE$.resolveServer(bloopVersion, true, this.out());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Dependency bloopDependency = (Dependency)tuple2._1();
                Resolution vanillaResolution = (Resolution)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)bloopDependency, (Object)vanillaResolution);
                Tuple2 tuple23 = tuple22;
                Dependency bloopDependency2 = (Dependency)tuple23._1();
                Resolution vanillaResolution2 = (Resolution)tuple23._2();
                if (vanillaResolution2.errors().isEmpty()) {
                    Seq<Path> jars = Installer$.MODULE$.fetchJars(vanillaResolution2, this.out());
                    object = jars.isEmpty() ? None$.MODULE$ : new Some((Object)new ResolvedAt(jars));
                } else {
                    Resolution versionlessResolution;
                    String stringBloopDep = Installer$.MODULE$.fromDependencyToString(bloopDependency2);
                    package$.MODULE$.printError(Feedback$.MODULE$.resolvingDependencyWithNoScalaSuffix(stringBloopDep), this.out());
                    Tuple2<Dependency, Resolution> tuple24 = Installer$.MODULE$.resolveServer(bloopVersion, false, this.out());
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    Resolution resolution = versionlessResolution = (Resolution)tuple24._2();
                    Resolution versionlessResolution2 = resolution;
                    if (versionlessResolution2.errors().isEmpty()) {
                        Seq<Path> jars = Installer$.MODULE$.fetchJars(versionlessResolution2, this.out());
                        object = jars.isEmpty() ? None$.MODULE$ : new Some((Object)new ResolvedAt(jars));
                    } else {
                        Seq prettyErrors = (Seq)vanillaResolution2.errors().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Seq errors;
                            Tuple2 tuple2;
                            block3: {
                                Tuple2 tuple22;
                                block2: {
                                    tuple22 = x0$1;
                                    if (tuple22 == null) break block2;
                                    tuple2 = (Tuple2)tuple22._1();
                                    errors = (Seq)tuple22._2();
                                    if (tuple2 != null) break block3;
                                }
                                throw new MatchError((Object)tuple22);
                            }
                            Module module = (Module)tuple2._1();
                            String version = (String)tuple2._2();
                            String string = new StringBuilder(4).append("  ").append(module).append(":").append(version).append("\n").append(((TraversableOnce)errors.map((Function1 & Serializable & scala.Serializable)x$10 -> new StringBuilder(4).append("    ").append(x$10.replace("\n", "    \n")).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString();
                            return string;
                        }, Seq$.MODULE$.canBuildFrom());
                        package$.MODULE$.printError(new StringBuilder(48).append("Failed to resolve '").append(bloopDependency2).append("'... the server cannot start!").toString(), this.out());
                        String errorMsg = new StringBuilder(18).append("Resolution error:\n").append(prettyErrors.mkString("\n")).toString();
                        object = None$.MODULE$;
                    }
                }
                return object;
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<Tuple2<String, Shell.StatusCommand>> bloopBackgroundError() {
        return this.bloopBackgroundError;
    }

    private void bloopBackgroundError_$eq(Option<Tuple2<String, Shell.StatusCommand>> x$1) {
        this.bloopBackgroundError = x$1;
    }

    public void startServerViaScriptInBackground(List<String> binary, List<String> jvmOptions) {
        this.shell().startThread("bsp-server-background", true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List list;
            Option<Object> option = this.nailgunPort();
            if (option instanceof Some) {
                Some some = (Some)option;
                int port = BoxesRunTime.unboxToInt((Object)some.value());
                list = (List)((List)binary.diff(this.bloopAdditionalArgs())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"server", (List)new .colon.colon((Object)((Object)BoxesRunTime.boxToInteger((int)port)).toString(), (List)Nil$.MODULE$)), List$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                list = (List)binary.$plus$plus((GenTraversableOnce)new .colon.colon((Object)"server", (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            List cmd = list;
            List startCmd = (List)cmd.$plus$plus((GenTraversableOnce)jvmOptions, List$.MODULE$.canBuildFrom());
            package$.MODULE$.println(Feedback$.MODULE$.startingBloopServer((List<String>)startCmd), this.out());
            Shell.StatusCommand status = this.shell().runCommand((List<String>)startCmd, Environment$.MODULE$.cwd(), (Option<Object>)None$.MODULE$, this.shell().runCommand$default$4(), this.shell().runCommand$default$5());
            this.bloopBackgroundError_$eq((Option<Tuple2<String, Shell.StatusCommand>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)startCmd.mkString(" ")), (Object)status)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$cli$3(String x$7) {
        String string = x$7;
        String string2 = "--skip-bsp-connection";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Promise failPromise$1(LauncherStatus status) {
        return this.startedServer.failure((Throwable)new RuntimeException(new StringBuilder(30).append("The server did not start, got ").append(status).toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LauncherStatus ifSessionIsLive$1(Function0 establishConnection) {
        Tuple2 tuple2;
        boolean bl = false;
        Some some = null;
        Option<Tuple2<String, Shell.StatusCommand>> option = this.bloopBackgroundError();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Tuple2 tuple22 = (Tuple2)some.value();
            if (tuple22 != null) {
                String cmd = (String)tuple22._1();
                Shell.StatusCommand status = (Shell.StatusCommand)tuple22._2();
                if (status.isOk()) {
                    package$.MODULE$.printError(new StringBuilder(58).append("Unexpected early exit of the bloop server spawned with '").append(cmd).append("'!").toString(), this.out());
                    if (status.output().isEmpty()) return LauncherStatus$FailedToConnectToServer$.MODULE$;
                    package$.MODULE$.printQuoted(status.output(), this.out());
                    return LauncherStatus$FailedToConnectToServer$.MODULE$;
                }
            }
        }
        if (bl && (tuple2 = (Tuple2)some.value()) != null) {
            String cmd = (String)tuple2._1();
            Shell.StatusCommand status = (Shell.StatusCommand)tuple2._2();
            package$.MODULE$.printError(new StringBuilder(39).append("Spawning a bloop server with '").append(cmd).append("' failed!").toString(), this.out());
            if (status.output().isEmpty()) return LauncherStatus$FailedToConnectToServer$.MODULE$;
            package$.MODULE$.printQuoted(status.output(), this.out());
            return LauncherStatus$FailedToConnectToServer$.MODULE$;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return (LauncherStatus)establishConnection.apply();
    }

    private final Either openBspSocket$1(boolean forceTcp, Function1 connect, BspBridge bridge$1) {
        Right right;
        block2: {
            Option<BspConnection> option;
            block3: {
                block4: {
                    BspBridge.RunningBspConnection runningBspConnection;
                    while (true) {
                        BspConnection bspConnection;
                        BspBridge.RunningBspConnection connection;
                        if ((option = bridge$1.waitForOpenBsp(connection = (BspBridge.RunningBspConnection)connect.apply((Object)BoxesRunTime.boxToBoolean((boolean)forceTcp)), bridge$1.waitForOpenBsp$default$2())) instanceof Some) {
                            Some some = (Some)option;
                            BspConnection c = (BspConnection)some.value();
                            right = scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Right().apply(bridge$1.connectToOpenSession(c)));
                            break block2;
                        }
                        if (!None$.MODULE$.equals(option)) break block3;
                        runningBspConnection = connection;
                        if (runningBspConnection != null && (bspConnection = runningBspConnection.bsp()) instanceof BspConnection.Tcp) break block4;
                        if (runningBspConnection == null) break;
                        package$.MODULE$.printError("Trying a tcp-based connection to the server instead...", this.out());
                        forceTcp = true;
                    }
                    throw new MatchError((Object)runningBspConnection);
                }
                Left left = scala.package$.MODULE$.Left().apply((Object)this.ifSessionIsLive$1((Function0 & Serializable & scala.Serializable)() -> {
                    package$.MODULE$.printError("The launcher failed to establish a bsp connection, aborting...", this.out());
                    return LauncherStatus$FailedToOpenBspConnection$.MODULE$;
                }));
                right = left;
                break block2;
            }
            throw new MatchError(option);
        }
        return right;
    }

    private static final boolean openBspSocket$default$1$1() {
        return false;
    }

    public LauncherMain(InputStream clientIn, OutputStream clientOut, PrintStream out, Charset charset, Shell shell, Option<Object> nailgunPort, Promise<BoxedUnit> startedServer, Function1<String, URL> generateBloopInstallerURL) {
        Nil$ nil$;
        this.clientIn = clientIn;
        this.clientOut = clientOut;
        this.out = out;
        this.shell = shell;
        this.nailgunPort = nailgunPort;
        this.startedServer = startedServer;
        this.generateBloopInstallerURL = generateBloopInstallerURL;
        this.launcherTmpDir = Files.createTempDirectory("bsp-launcher", new FileAttribute[0]);
        Option<Object> option = nailgunPort;
        if (option instanceof Some) {
            Some some = (Some)option;
            int port = BoxesRunTime.unboxToInt((Object)some.value());
            nil$ = new .colon.colon((Object)"--nailgun-port", (List)new .colon.colon((Object)((Object)BoxesRunTime.boxToInteger((int)port)).toString(), (List)Nil$.MODULE$));
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        this.bloopAdditionalArgs = nil$;
        this.bloopBackgroundError = None$.MODULE$;
    }
}

