/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;
import ch.qos.logback.core.net.SyslogWriter;
import java.io.IOException;

public class SyslogAppender
extends SyslogAppenderBase {
    String prefixPattern;
    PatternLayout prefixLayout;
    public static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %logger %msg";

    public Layout buildLayout(String facilityStr) {
        this.prefixPattern = "%syslogStart{" + facilityStr + "}%nopex";
        this.prefixLayout = new PatternLayout();
        this.prefixLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        this.prefixLayout.setPattern(this.prefixPattern);
        this.prefixLayout.setContext(this.getContext());
        this.prefixLayout.start();
        PatternLayout fullLayout = new PatternLayout();
        fullLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        if (this.suffixPattern == null) {
            this.suffixPattern = DEFAULT_SUFFIX_PATTERN;
        }
        fullLayout.setPattern(this.prefixPattern + this.suffixPattern);
        fullLayout.setContext(this.getContext());
        fullLayout.start();
        return fullLayout;
    }

    public int getSeverityForEvent(Object eventObject) {
        LoggingEvent event = (LoggingEvent)eventObject;
        return LevelToSyslogSeverity.convert(event);
    }

    protected void postProcess(Object eventObject, SyslogWriter sw) {
        LoggingEvent event = (LoggingEvent)eventObject;
        String prefix = this.prefixLayout.doLayout(event);
        if (event.getThrowableInformation() != null) {
            String[] strRep = event.getThrowableInformation().getThrowableStrRep();
            try {
                for (String line : strRep) {
                    sw.write(prefix + line);
                    sw.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

