/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ContextListener;
import ch.qos.logback.classic.spi.LoggerComparator;
import ch.qos.logback.classic.spi.LoggerContextRemoteView;
import ch.qos.logback.classic.spi.TurboFilterAttachable;
import ch.qos.logback.classic.spi.TurboFilterAttachableImpl;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerContext
extends ContextBase
implements ILoggerFactory,
TurboFilterAttachable,
LifeCycle {
    public static final String ROOT_NAME = "root";
    final Logger root;
    private int size;
    private int noAppenderWarning = 0;
    private final List<ContextListener> contextListenerList = new ArrayList<ContextListener>();
    private Hashtable<String, Logger> loggerCache = new Hashtable();
    LoggerContextRemoteView loggerContextRemoteView = new LoggerContextRemoteView(this);
    TurboFilterAttachableImpl cfai = null;
    boolean started = false;

    public LoggerContext() {
        this.root = new Logger(ROOT_NAME, null, this);
        this.root.setLevel(Level.DEBUG);
        this.loggerCache.put(ROOT_NAME, this.root);
        this.putObject("EVALUATOR_MAP", new HashMap());
        this.size = 1;
    }

    private void syncRemoteView() {
        this.loggerContextRemoteView = new LoggerContextRemoteView(this);
        for (Logger logger : this.loggerCache.values()) {
            logger.buildRemoteView();
        }
    }

    public void putProperty(String key, String val) {
        super.putProperty(key, val);
        this.syncRemoteView();
    }

    public void setName(String name) {
        super.setName(name);
        this.syncRemoteView();
    }

    public final Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Logger getLogger(String name) {
        int h;
        if (ROOT_NAME.equalsIgnoreCase(name)) {
            return this.root;
        }
        int i = 0;
        Logger logger = this.root;
        Logger childLogger = this.loggerCache.get(name);
        if (childLogger != null) {
            return childLogger;
        }
        do {
            String childName = (h = name.indexOf(46, i)) == -1 ? name : name.substring(0, h);
            i = h + 1;
            Logger logger2 = logger;
            synchronized (logger2) {
                childLogger = logger.getChildByName(childName);
                if (childLogger == null) {
                    childLogger = logger.createChildByName(childName);
                    this.loggerCache.put(childName, childLogger);
                    this.incSize();
                }
            }
            logger = childLogger;
        } while (h != -1);
        return childLogger;
    }

    private synchronized void incSize() {
        ++this.size;
    }

    synchronized int size() {
        return this.size;
    }

    public Logger exists(String name) {
        return this.loggerCache.get(name);
    }

    final void noAppenderDefinedWarning(Logger logger) {
        if (this.noAppenderWarning++ == 0) {
            this.getStatusManager().add((Status)new ErrorStatus("No appenders present in context [" + this.getName() + "] for logger [" + logger.getName() + "].", (Object)logger));
        }
    }

    public List<Logger> getLoggerList() {
        Collection<Logger> collection = this.loggerCache.values();
        ArrayList<Logger> loggerList = new ArrayList<Logger>(collection);
        Collections.sort(loggerList, new LoggerComparator());
        return loggerList;
    }

    public LoggerContextRemoteView getLoggerContextRemoteView() {
        return this.loggerContextRemoteView;
    }

    public void shutdownAndReset() {
        this.root.recursiveReset();
        this.fireOnReset();
    }

    @Override
    public void addTurboFilter(TurboFilter newFilter) {
        if (this.cfai == null) {
            this.cfai = new TurboFilterAttachableImpl();
        }
        this.cfai.addTurboFilter(newFilter);
    }

    @Override
    public void clearAllTurboFilters() {
        if (this.cfai == null) {
            return;
        }
        this.cfai.clearAllTurboFilters();
        this.cfai = null;
    }

    @Override
    public final FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (this.cfai == null) {
            return FilterReply.NEUTRAL;
        }
        return this.cfai.getTurboFilterChainDecision(marker, logger, level, format, params, t);
    }

    public final FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object param, Throwable t) {
        if (this.cfai == null) {
            return FilterReply.NEUTRAL;
        }
        return this.cfai.getTurboFilterChainDecision(marker, logger, level, format, new Object[]{param}, t);
    }

    public final FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object param1, Object param2, Throwable t) {
        if (this.cfai == null) {
            return FilterReply.NEUTRAL;
        }
        return this.cfai.getTurboFilterChainDecision(marker, logger, level, format, new Object[]{param1, param2}, t);
    }

    @Override
    public TurboFilter getFirstTurboFilter() {
        if (this.cfai == null) {
            return null;
        }
        return this.cfai.getFirstTurboFilter();
    }

    public void addListener(ContextListener listener) {
        this.contextListenerList.add(listener);
    }

    public void removeListener(ContextListener listener) {
        this.contextListenerList.remove(listener);
    }

    private void fireOnReset() {
        for (ContextListener listener : this.contextListenerList) {
            listener.onReset(this);
        }
    }

    private void fireOnStart() {
        for (ContextListener listener : this.contextListenerList) {
            listener.onStart(this);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
        this.fireOnStart();
    }

    public void stop() {
        this.started = false;
    }
}

