/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.AsynchronousCompressor;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedRollingPolicy<E>
extends RollingPolicyBase
implements TriggeringPolicy<E> {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using TimeBasedRollingPolicy. ";
    static final int NO_DELETE_HISTORY = 0;
    FileNamePattern fileNamePatternWCS;
    private Compressor compressor;
    private RenameUtil renameUtil = new RenameUtil();
    Future<?> future;
    private int maxHistory = 0;
    private ArchiveRemover archiveRemover;
    TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedTriggering;

    @Override
    public void start() {
        this.renameUtil.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addWarn(FNP_NOT_SET);
            this.addWarn("See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
            throw new IllegalStateException("The FileNamePattern option must be set before using TimeBasedRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        this.compressor = new Compressor(this.compressionMode);
        this.compressor.setContext(this.context);
        this.fileNamePatternWCS = new FileNamePattern(TimeBasedRollingPolicy.computeFileNameStr_WCS(this.fileNamePatternStr, this.compressionMode), this.context);
        this.addInfo("Will use the pattern " + this.fileNamePatternWCS + " for the active file");
        if (this.timeBasedTriggering == null) {
            this.timeBasedTriggering = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        }
        this.timeBasedTriggering.setContext(this.context);
        this.timeBasedTriggering.setTimeBasedRollingPolicy(this);
        this.timeBasedTriggering.start();
        if (this.maxHistory != 0) {
            this.archiveRemover = this.timeBasedTriggering.getArchiveRemover();
            this.archiveRemover.setMaxHistory(this.maxHistory);
        }
    }

    public void setTimeBasedFileNamingAndTriggeringPolicy(TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedTriggering) {
        this.timeBasedTriggering = timeBasedTriggering;
    }

    public TimeBasedFileNamingAndTriggeringPolicy<E> getTimeBasedFileNamingAndTriggeringPolicy() {
        return this.timeBasedTriggering;
    }

    static String computeFileNameStr_WCS(String fileNamePatternStr, CompressionMode compressionMode) {
        int len = fileNamePatternStr.length();
        switch (compressionMode) {
            case GZ: {
                return fileNamePatternStr.substring(0, len - 3);
            }
            case ZIP: {
                return fileNamePatternStr.substring(0, len - 4);
            }
            case NONE: {
                return fileNamePatternStr;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    @Override
    public void rollover() throws RolloverFailure {
        String elapsedPeriodsFileName = this.timeBasedTriggering.getElapsedPeriodsFileName();
        if (this.compressionMode == CompressionMode.NONE) {
            if (this.getParentsRawFileProperty() != null) {
                this.renameUtil.rename(this.getParentsRawFileProperty(), elapsedPeriodsFileName);
            }
        } else {
            this.future = this.getParentsRawFileProperty() == null ? this.asyncCompress(elapsedPeriodsFileName, elapsedPeriodsFileName) : this.renamedRawAndAsyncCompress(elapsedPeriodsFileName);
        }
        if (this.archiveRemover != null) {
            this.archiveRemover.clean(new Date(this.timeBasedTriggering.getCurrentTime()));
        }
    }

    Future asyncCompress(String nameOfFile2Compress, String nameOfCompressedFile) throws RolloverFailure {
        AsynchronousCompressor ac = new AsynchronousCompressor(this.compressor);
        return ac.compressAsynchronously(nameOfFile2Compress, nameOfCompressedFile);
    }

    Future renamedRawAndAsyncCompress(String nameOfCompressedFile) throws RolloverFailure {
        String parentsRawFile = this.getParentsRawFileProperty();
        String tmpTarget = parentsRawFile + System.nanoTime() + ".tmp";
        this.renameUtil.rename(parentsRawFile, tmpTarget);
        return this.asyncCompress(tmpTarget, nameOfCompressedFile);
    }

    @Override
    public String getActiveFileName() {
        String parentsRawFileProperty = this.getParentsRawFileProperty();
        if (parentsRawFileProperty != null) {
            return parentsRawFileProperty;
        }
        return this.timeBasedTriggering.getCurrentPeriodsFileNameWithoutCompressionSuffix();
    }

    @Override
    public boolean isTriggeringEvent(File activeFile, E event) {
        return this.timeBasedTriggering.isTriggeringEvent(activeFile, event);
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public String toString() {
        return "c.q.l.core.rolling.TimeBasedRollingPolicy";
    }
}

